/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class GourmaryllisBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    public static final String TAG_LAST_FOODS = "lastFoods";
    public static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private static final int RANGE = 1;
    private static final double[] STREAK_MULTIPLIERS = new double[]{0.0, 1.0, 1.3, 1.5, 1.6, 1.7, 1.75, 1.8};
    private static final int MAX_FOOD_VALUE = 12;
    private static final int FOOD_COOLDOWN_FACTOR = 10;
    private static final int FOOD_MANA_FACTOR = 70;
    private static final int MAX_MANA = GourmaryllisBlockEntity.getDigestingMana(12, STREAK_MULTIPLIERS[STREAK_MULTIPLIERS.length - 1]);
    private int cooldown = 0;
    private int digestingMana = 0;
    private final List<ItemStack> lastFoods = new LinkedList<ItemStack>();
    private int streakLength = -1;
    private int lastFoodCount = 0;

    public GourmaryllisBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.GOURMARYLLIS, pos, state);
    }

    private int getMaxStreak() {
        return STREAK_MULTIPLIERS.length - 1;
    }

    private double getMultiplierForStreak(int index) {
        if (index == 0) {
            return 1.0 / (double)(++this.lastFoodCount);
        }
        this.lastFoodCount = 1;
        return STREAK_MULTIPLIERS[index];
    }

    private int processFood(ItemStack food) {
        ListIterator<ItemStack> it = this.lastFoods.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            ItemStack streakFood = it.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)streakFood, (ItemStack)food)) continue;
            it.remove();
            this.lastFoods.add(0, streakFood);
            return index;
        }
        ItemStack newestFood = food.copyWithCount(1);
        this.lastFoods.add(0, newestFood);
        if (this.lastFoods.size() >= this.getMaxStreak()) {
            this.lastFoods.remove(this.lastFoods.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.digestingMana != 0) {
            int munchInterval = 2 + 2 * this.lastFoodCount;
            if (this.cooldown == 0) {
                this.addMana(this.digestingMana);
                this.digestingMana = 0;
                float burpPitch = (float)Math.pow(2.0, (double)(this.streakLength == 0 ? -this.lastFoodCount : this.streakLength) / 12.0);
                this.getLevel().playSound(null, this.getEffectivePos(), SoundEvents.PLAYER_BURP, SoundSource.BLOCKS, 1.0f, burpPitch);
                this.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_DEACTIVATE, this.getEffectivePos());
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.getLevel().playSound(null, this.getEffectivePos(), SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 0.5f, 1.0f);
                Vec3 offset = this.getLevel().getBlockState(this.getEffectivePos()).getOffset((BlockGetter)this.getLevel(), this.getEffectivePos()).add(0.4, 0.6, 0.4);
                ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.lastFoods.get(0)), (double)this.getEffectivePos().getX() + offset.x, (double)this.getEffectivePos().getY() + offset.y, (double)this.getEffectivePos().getZ() + offset.z, 10, 0.1, 0.1, 0.1, 0.03);
            }
        }
        List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, new AABB(this.getEffectivePos()).inflate(1.0));
        for (ItemEntity item : items) {
            ItemStack stack = item.getItem();
            if (!DelayHelper.canInteractWithImmediate(this, item) || !stack.getItem().components().has(DataComponents.FOOD)) continue;
            if (this.cooldown <= 0) {
                this.streakLength = Math.min(this.streakLength + 1, this.processFood(stack));
                int val = GourmaryllisBlockEntity.getFoodValue(stack);
                this.digestingMana = GourmaryllisBlockEntity.getDigestingMana(val, this.getMultiplierForStreak(this.streakLength));
                this.cooldown = GourmaryllisBlockEntity.getCooldown(val);
                item.playSound(SoundEvents.GENERIC_EAT, 0.2f, 0.6f);
                this.getLevel().gameEvent(null, (Holder)GameEvent.EAT, item.position());
                this.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, this.getEffectivePos());
                this.sync();
                ((ServerLevel)this.getLevel()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), item.getX(), item.getY(), item.getZ(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            item.discard();
        }
    }

    private static int getCooldown(int foodValue) {
        return Math.max(1, foodValue * 10);
    }

    private static int getDigestingMana(int foodValue, double streakFactor) {
        return Math.max(1, (int)((double)(foodValue * foodValue * 70) * streakFactor));
    }

    private static int getFoodValue(ItemStack stack) {
        FoodProperties foodProperties = XplatAbstractions.INSTANCE.getFoodProperties(stack);
        int nutrition = foodProperties != null ? foodProperties.nutrition() : 0;
        return Math.min(12, nutrition);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_COOLDOWN, this.cooldown);
        cmp.putInt(TAG_DIGESTING_MANA, this.digestingMana);
        ListTag foodList = new ListTag();
        for (ItemStack food : this.lastFoods) {
            foodList.add((Object)new CompoundTag());
        }
        cmp.put(TAG_LAST_FOODS, (Tag)foodList);
        cmp.putInt(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
        cmp.putInt(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.cooldown = cmp.getInt(TAG_COOLDOWN);
        this.digestingMana = cmp.getInt(TAG_DIGESTING_MANA);
        this.lastFoods.clear();
        ListTag foodList = cmp.getList(TAG_LAST_FOODS, 10);
        for (int i = 0; i < foodList.size(); ++i) {
        }
        this.lastFoodCount = cmp.getInt(TAG_LAST_FOOD_COUNT);
        this.streakLength = cmp.getInt(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return MAX_MANA;
    }

    @Override
    public int getColor() {
        return 13882884;
    }
}

