/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.CellularBlockEntity;

public class DandelifeonBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final int RANGE = 12;
    public static final int SPEED = 10;
    public static final int OVERGROWN_SPEED = 5;
    public static final int MAX_MANA_GENERATIONS = 100;
    public static final int MANA_PER_GEN = 60;
    private static final String TAG_RADIUS = "radius";
    private int radius = 12;
    private static final int[][] ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

    public DandelifeonBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.DANDELIFEON, pos, state);
    }

    public int getRange() {
        return this.radius;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.getLevel().isClientSide) {
            if (this.shouldTick(this.getLevel().getGameTime())) {
                this.runSimulation();
            } else if (this.shouldTick(this.getLevel().getGameTime() + 1L)) {
                int diameter = this.radius * 2;
                for (int i = 0; i <= diameter; ++i) {
                    for (int j = 0; j <= diameter; ++j) {
                        BlockPos pos = this.getEffectivePos().offset(-this.radius + i, 0, -this.radius + j);
                        BlockEntity tile = this.getLevel().getBlockEntity(pos);
                        if (!(tile instanceof CellularBlockEntity)) continue;
                        ((CellularBlockEntity)tile).claim(this);
                    }
                }
            }
        }
    }

    private boolean shouldTick(long gameTime) {
        return (!this.overgrowthBoost && gameTime % 10L == 0L || this.overgrowthBoost && (gameTime + 5L) % 10L == 0L) && this.getLevel().hasNeighborSignal(this.getBlockPos());
    }

    private void runSimulation() {
        CellTable table = new CellTable(this.radius, this);
        ArrayList<LifeUpdate> changes = new ArrayList<LifeUpdate>();
        boolean wipe = false;
        for (int i = 0; i < table.diameter; ++i) {
            for (int j = 0; j < table.diameter; ++j) {
                int oldLife = table.at(i, j);
                int adj = table.getAdjCells(i, j);
                int newLife = adj == 3 && oldLife == -1 ? table.getSpawnCellGeneration(i, j) : ((adj == 2 || adj == 3) && Cell.isLive(oldLife) ? oldLife + 1 : -1);
                int xdist = Math.abs(i - this.radius);
                int zdist = Math.abs(j - this.radius);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && Cell.isLive(newLife)) {
                    if (oldLife == 1) {
                        newLife = -1;
                    } else {
                        oldLife = newLife;
                        newLife = -2;
                        wipe = true;
                    }
                }
                if (newLife == oldLife) continue;
                changes.add(new LifeUpdate(i, j, newLife, oldLife));
            }
        }
        for (LifeUpdate change : changes) {
            BlockPos pos_ = table.center.offset(-this.radius + change.x(), 0, -this.radius + change.z());
            int newLife = change.newLife();
            if (newLife != -2 && wipe) {
                newLife = -1;
            }
            this.setBlockForGeneration(pos_, Math.min(newLife, 100), change.oldLife());
        }
    }

    void setBlockForGeneration(BlockPos pos, int cell, int prevCell) {
        Level world = this.getLevel();
        BlockState stateAt = world.getBlockState(pos);
        BlockEntity tile = world.getBlockEntity(pos);
        if (cell == -2) {
            if (stateAt.isAir()) {
                int val = prevCell * 60;
                world.removeBlock(pos, true);
                this.addMana(val);
                this.sync();
            }
        } else if (tile instanceof CellularBlockEntity) {
            CellularBlockEntity cellBlock = (CellularBlockEntity)tile;
            cellBlock.setNextGeneration(this, cell);
        } else if (Cell.isLive(cell) && stateAt.isAir()) {
            world.setBlockAndUpdate(pos, BotaniaBlocks.cellBlock.defaultBlockState());
            tile = world.getBlockEntity(pos);
            ((CellularBlockEntity)tile).setNextGeneration(this, cell);
            ((CellularBlockEntity)tile).setGeneration(-1);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.radius);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        if (this.radius != 12) {
            cmp.putInt(TAG_RADIUS, this.radius);
        }
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.radius = cmp.contains(TAG_RADIUS) ? cmp.getInt(TAG_RADIUS) : 12;
    }

    private static class CellTable {
        public final BlockPos center;
        public final int diameter;
        private int[][] cells;

        public CellTable(int range, DandelifeonBlockEntity dandie) {
            this.center = dandie.getEffectivePos();
            this.diameter = range * 2 + 1;
            this.cells = new int[this.diameter + 2][this.diameter + 2];
            for (int i = -1; i <= this.diameter; ++i) {
                for (int j = -1; j <= this.diameter; ++j) {
                    BlockPos pos = this.center.offset(-range + i, 0, -range + j);
                    this.cells[i + 1][j + 1] = CellTable.getCellGeneration(pos, dandie, this.onBoundary(i, j));
                }
            }
        }

        private static int getCellGeneration(BlockPos pos, DandelifeonBlockEntity dandie, boolean onBoundary) {
            BlockEntity tile = dandie.getLevel().getBlockEntity(pos);
            if (tile instanceof CellularBlockEntity) {
                CellularBlockEntity cell = (CellularBlockEntity)tile;
                return onBoundary ? (cell.hasActiveParent(dandie) ? Cell.boundaryPunish(cell.getGeneration()) : -1) : cell.getGeneration();
            }
            return -1;
        }

        public boolean inBounds(int x, int z) {
            return x >= 0 && z >= 0 && x < this.diameter && z < this.diameter;
        }

        private boolean onBoundary(int x, int z) {
            return x == -1 || z == -1 || x == this.diameter || z == this.diameter;
        }

        public int getAdjCells(int x, int z) {
            int count = 0;
            for (int[] shift : ADJACENT_BLOCKS) {
                if (!Cell.isLive(this.at(x + shift[0], z + shift[1]))) continue;
                ++count;
            }
            return count;
        }

        public int getSpawnCellGeneration(int x, int z) {
            int max = -1;
            for (int[] shift : ADJACENT_BLOCKS) {
                max = Math.max(max, this.at(x + shift[0], z + shift[1]));
            }
            return max == -1 ? -1 : max + 1;
        }

        public int at(int x, int z) {
            return this.cells[x + 1][z + 1];
        }
    }

    public static final class Cell {
        public static final int CONSUME = -2;
        public static final int DEAD = -1;

        private Cell() {
        }

        public static boolean isLive(int i) {
            return i >= 0;
        }

        public static int boundaryPunish(int life) {
            return Cell.isLive(life) ? life / 4 : life;
        }
    }

    private record LifeUpdate(int x, int z, int newLife, int oldLife) {
    }
}

