/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.MathHelper;

public class TangleberrieBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final double RANGE = 7.0;
    private static final double MAXDISTANCE = 6.0;
    private static final double RANGE_MINI = 3.0;
    private static final double MAXDISTANCE_MINI = 2.0;

    public TangleberrieBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TangleberrieBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.TANGLEBERRIE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getMana() > 0) {
            double x1 = (double)this.getEffectivePos().getX() + 0.5;
            double y1 = (double)this.getEffectivePos().getY() + 0.5;
            double z1 = (double)this.getEffectivePos().getZ() + 0.5;
            double maxDist = this.getMaxDistance();
            double range = this.getRange();
            AABB boundingBox = new AABB(x1 - range, y1 - range, z1 - range, x1 + range + 1.0, y1 + range + 1.0, z1 + range + 1.0);
            List entities = this.getLevel().getEntitiesOfClass(LivingEntity.class, boundingBox);
            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.5f, 0.5f, 0.5f, 3);
            for (LivingEntity entity : entities) {
                double z2;
                double y2;
                double x2;
                float distance;
                if (entity instanceof Player || !entity.canUsePortal(false) || !((double)(distance = MathHelper.pointDistanceSpace(x1, y1, z1, x2 = entity.getX(), y2 = entity.getY(), z2 = entity.getZ())) > maxDist) || !((double)distance < range)) continue;
                MathHelper.setEntityMotionFromVector((Entity)entity, new Vec3(x1, y1, z1), this.getMotionVelocity(entity));
                if (this.getLevel().random.nextInt(3) != 0) continue;
                this.level.addParticle((ParticleOptions)data, x2 + Math.random() * (double)entity.getBbWidth(), y2 + Math.random() * (double)entity.getBbHeight(), z2 + Math.random() * (double)entity.getBbWidth(), 0.0, 0.0, 0.0);
            }
            if (this.ticksExisted % 4 == 0) {
                this.addMana(-1);
                this.sync();
            }
        }
    }

    double getMaxDistance() {
        return 6.0;
    }

    double getRange() {
        return 7.0;
    }

    float getMotionVelocity(LivingEntity entity) {
        return Math.max(entity.getSpeed() / 2.0f, 0.05f);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getMaxDistance() == this.getRange()) {
            return null;
        }
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getMaxDistance());
    }

    @Override
    public int getColor() {
        return 4946300;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    public static class Mini
    extends TangleberrieBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.TANGLEBERRIE_CHIBI, pos, state);
        }

        @Override
        public double getMaxDistance() {
            return 2.0;
        }

        @Override
        public double getRange() {
            return 3.0;
        }
    }
}

