/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class SolegnoliaBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final double RANGE = 5.0;
    private static final double RANGE_MINI = 1.0;
    private static final Set<SolegnoliaBlockEntity> existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());

    protected SolegnoliaBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SolegnoliaBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.SOLEGNOLIA, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!existingFlowers.contains(this)) {
            existingFlowers.add(this);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        existingFlowers.remove(this);
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public static boolean hasSolegnoliaAround(Entity e) {
        for (SolegnoliaBlockEntity flower : existingFlowers) {
            if (flower.redstoneSignal != 0 || flower.getLevel() != e.level() || !(flower.getEffectivePos().distToCenterSqr(e.getX(), e.getY(), e.getZ()) <= flower.getRange() * flower.getRange())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxMana() {
        return 1;
    }

    @Override
    public int getColor() {
        return 13212749;
    }

    public double getRange() {
        return 5.0;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SolegnoliaBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.SOLEGNOLIA_CHIBI, pos, state);
        }

        @Override
        public double getRange() {
            return 1.0;
        }
    }
}

