/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.item.FlowerPlaceable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.HopperhockBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class RannuncarpusBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final int PICKUP_RANGE = 2;
    private static final int PICKUP_RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;
    private static final String TAG_STATE_SENSITIVE = "stateSensitive";
    public static final int PLACE_INTERVAL_TICKS = 10;
    private boolean stateSensitive = false;

    protected RannuncarpusBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RannuncarpusBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.RANNUNCARPUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, AABB.encapsulatingFullBlocks((BlockPos)this.getBlockPos().offset(-2, -3, -2), (BlockPos)this.getBlockPos().offset(2, 3, 2)));
            List<ItemStack> filter = HopperhockBlockEntity.getFilterForInventory(this.getLevel(), this.getFilterPos(), false);
            for (ItemEntity item : items) {
                BlockPos coords;
                ItemStack stack;
                if (!DelayHelper.canInteractWith(this, item) || !HopperhockBlockEntity.canAcceptItem(stack = item.getItem(), filter, 0)) continue;
                Item stackItem = stack.getItem();
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stackItem);
                if (BotaniaConfig.common().rannuncarpusModBlacklist().contains(id.getNamespace()) || BotaniaConfig.common().rannuncarpusItemBlacklist().contains(id.toString()) || !(stackItem instanceof BlockItem) && !(stackItem instanceof FlowerPlaceable) || (coords = this.getCandidatePosition(this.getLevel().random, stack)) == null) continue;
                BlockPlaceContext ctx = this.getBlockPlaceContext(stack, coords);
                boolean success = false;
                if (stackItem instanceof FlowerPlaceable) {
                    FlowerPlaceable flowerPlaceable = (FlowerPlaceable)stackItem;
                    success = flowerPlaceable.tryPlace(this, ctx);
                }
                if (!success && stackItem instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)stackItem;
                    success = blockItem.place(ctx).consumesAction();
                }
                if (!success) continue;
                if (BotaniaConfig.common().blockBreakParticles()) {
                    BlockState state = this.getLevel().getBlockState(ctx.getClickedPos());
                    this.getLevel().levelEvent(2001, coords, Block.getId((BlockState)state));
                }
                if (this.getMana() > 1) {
                    this.addMana(-1);
                }
                EntityHelper.syncItem(item);
                return;
            }
        }
    }

    @NotNull
    private BlockPlaceContext getBlockPlaceContext(ItemStack stack, BlockPos coords) {
        BlockHitResult ray = new BlockHitResult(new Vec3((double)coords.getX() + 0.5, (double)(coords.getY() + 1), (double)coords.getZ() + 0.5), Direction.UP, coords, false);
        return new RannuncarpusPlaceContext(this.getLevel(), stack, ray, this.worldPosition);
    }

    private BlockPos getFilterPos() {
        return this.getBlockPos().below(this.isFloating() ? 1 : 2);
    }

    public BlockState getUnderlyingBlock() {
        return this.getLevel().getBlockState(this.getFilterPos());
    }

    @Nullable
    private BlockPos getCandidatePosition(RandomSource rand, ItemStack stack) {
        int rangePlace = this.getPlaceRange();
        int rangePlaceY = this.getVerticalPlaceRange();
        BlockPos center = this.getEffectivePos();
        BlockState filter = this.getUnderlyingBlock();
        ArrayList<BlockPos> emptyPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> additivePositions = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(-rangePlace, -rangePlaceY, -rangePlace), (BlockPos)center.offset(rangePlace, rangePlaceY, rangePlace))) {
            BlockState state = this.getLevel().getBlockState(pos);
            BlockPos placementPos = pos.above();
            BlockState up = this.getLevel().getBlockState(placementPos);
            boolean matches = this.stateSensitive ? state == filter : state.is(filter.getBlock());
            if (!matches) continue;
            if (RannuncarpusBlockEntity.isAirOrDifferentReplaceableBlock(up, stack)) {
                emptyPositions.add(pos.immutable());
                continue;
            }
            if (!up.canBeReplaced(this.getBlockPlaceContext(stack, placementPos))) continue;
            additivePositions.add(pos.immutable());
        }
        return !emptyPositions.isEmpty() ? (BlockPos)emptyPositions.get(rand.nextInt(emptyPositions.size())) : (!additivePositions.isEmpty() ? (BlockPos)additivePositions.get(rand.nextInt(additivePositions.size())) : null);
    }

    private static boolean isAirOrDifferentReplaceableBlock(BlockState state, ItemStack stack) {
        return state.isAir() || state.canBeReplaced() && !stack.is(state.getBlock().asItem());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.stateSensitive = cmp.contains(TAG_STATE_SENSITIVE) ? cmp.getBoolean(TAG_STATE_SENSITIVE) : true;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putBoolean(TAG_STATE_SENSITIVE, this.stateSensitive);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || player.isShiftKeyDown()) {
            this.stateSensitive = !this.stateSensitive;
            this.setChanged();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getPlaceRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getPlaceRange() == 2 && this.getEffectivePos().equals((Object)this.getBlockPos())) {
            return null;
        }
        return RadiusDescriptor.Rectangle.square(this.getBlockPos(), 2);
    }

    public int getPlaceRange() {
        return this.getMana() > 0 ? 8 : 6;
    }

    public int getVerticalPlaceRange() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    private static class RannuncarpusPlaceContext
    extends BlockPlaceContext {
        private final Direction[] lookDirs;
        private final float placementYaw;

        public RannuncarpusPlaceContext(Level world, ItemStack stack, BlockHitResult rtr, BlockPos flowerPos) {
            super(world, null, InteractionHand.MAIN_HAND, stack, rtr);
            int dx = rtr.getBlockPos().getX() - flowerPos.getX();
            int dy = rtr.getBlockPos().getY() - flowerPos.getY();
            int dz = rtr.getBlockPos().getZ() - flowerPos.getZ();
            Direction xClosest = dx >= 0 ? Direction.EAST : Direction.WEST;
            Direction yClosest = dy >= 0 ? Direction.UP : Direction.DOWN;
            Direction zClosest = dz >= 0 ? Direction.SOUTH : Direction.NORTH;
            List<Direction> directions = RannuncarpusPlaceContext.sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));
            Direction first = directions.get(0);
            Direction second = directions.get(1);
            Direction third = directions.get(2);
            this.lookDirs = new Direction[]{first, second, third, third.getOpposite(), second.getOpposite(), first.getOpposite()};
            this.placementYaw = (float)(-Mth.atan2((double)dx, (double)dz) * 180.0 / Math.PI);
        }

        private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
            if (aInt >= bInt) {
                if (bInt >= cInt) {
                    return ImmutableList.of(a, b, c);
                }
                return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
            }
            if (bInt >= cInt) {
                return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
            }
            return ImmutableList.of(c, b, a);
        }

        @NotNull
        public Direction getNearestLookingDirection() {
            return this.getNearestLookingDirections()[0];
        }

        @NotNull
        public Direction[] getNearestLookingDirections() {
            return this.lookDirs;
        }

        @NotNull
        public Direction getHorizontalDirection() {
            return this.getNearestLookingDirection().getAxis().isHorizontal() ? this.getNearestLookingDirection() : this.getNearestLookingDirections()[1];
        }

        public float getRotation() {
            return this.placementYaw;
        }
    }

    public static class Mini
    extends RannuncarpusBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.RANNUNCARPUS_CHIBI, pos, state);
        }

        @Override
        public int getPlaceRange() {
            return this.getMana() > 0 ? 3 : 2;
        }

        @Override
        public int getVerticalPlaceRange() {
            return 2;
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<RannuncarpusBlockEntity> {
        public WandHud(RannuncarpusBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack filterStack = new ItemStack((ItemLike)((RannuncarpusBlockEntity)this.flower).getUnderlyingBlock().getBlock());
            int color = ((RannuncarpusBlockEntity)this.flower).getColor();
            String mode = I18n.get((String)("botaniamisc.rannuncarpus." + (((RannuncarpusBlockEntity)this.flower).stateSensitive ? "state_sensitive" : "state_insensitive")), (Object[])new Object[0]);
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            int modeWidth = mc.font.width(mode);
            int modeTextStart = (mc.getWindow().getGuiScaledWidth() - modeWidth) / 2;
            int minWidth = Math.max(RenderHelper.itemWithNameWidth(mc, filterStack), modeWidth) + 4;
            super.renderHUD(gui, mc, minWidth / 2, minWidth / 2, filterStack.isEmpty() ? 40 : 60);
            gui.drawString(mc.font, mode, modeTextStart, centerY + 30, color);
            RenderHelper.renderItemWithNameCentered(gui, mc, filterStack, centerY + 40, color);
        }
    }
}

