/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.AnimalAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class PollidisiacBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FEEDING_MODE = "mode";
    private static final int RANGE = 6;
    private static final int MANA_COST = 12;
    @NotNull
    private Mode mode = Mode.FEED_ADULTS;

    public PollidisiacBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
    }

    @Override
    public void tickFlower() {
        List<ItemEntity> items;
        super.tickFlower();
        if (!this.getLevel().isClientSide && this.getMana() >= 12 && !(items = this.getItems()).isEmpty()) {
            List<Animal> animals = this.getAnimals();
            this.feedAnimal(animals, items);
        }
    }

    @NotNull
    private List<ItemEntity> getItems() {
        AABB pickupBounds = new AABB(this.getBlockPos()).inflate(6.0);
        return this.getLevel().getEntitiesOfClass(ItemEntity.class, pickupBounds, itemEntity -> DelayHelper.canInteractWith(this, itemEntity));
    }

    @NotNull
    private List<Animal> getAnimals() {
        AABB bounds = new AABB(this.getEffectivePos()).inflate(6.0);
        return this.getLevel().getEntitiesOfClass(Animal.class, bounds, (Predicate)this.mode);
    }

    private void feedAnimal(List<Animal> animals, List<ItemEntity> items) {
        Collections.shuffle(animals);
        animals.sort(Comparator.comparing(AgeableMob::isBaby).thenComparingInt(animal -> Math.min(animal.getAge(), 0)));
        for (Animal animal2 : animals) {
            if (animal2.getAge() == 0 && !animal2.isInLove() || animal2.getAge() < -600 && -animal2.getAge() % 100 == 0) {
                for (ItemEntity item : items) {
                    if (!animal2.isFood(item.getItem())) continue;
                    this.consumeFoodItemAndMana(item);
                    if (animal2.isBaby()) {
                        animal2.ageUp(AgeableMob.getSpeedUpSecondsWhenFeeding((int)(-animal2.getAge())), true);
                    } else {
                        animal2.setInLoveTime(1200);
                        ((AnimalAccessor)animal2).botania_setLoveCause(null);
                    }
                    this.getLevel().broadcastEntityEvent((Entity)animal2, (byte)18);
                    break;
                }
                if (this.getMana() < 12) break;
            }
            if (animal2.isBaby() || !PollidisiacBlockEntity.isBrownMooshroomWithoutEffect(animal2)) continue;
            for (ItemEntity item : items) {
                SuspiciousEffectHolder effectHolder;
                ItemStack stack = item.getItem();
                if (!stack.is(ItemTags.SMALL_FLOWERS) || (effectHolder = SuspiciousEffectHolder.tryGet((ItemLike)stack.getItem())) == null) continue;
                this.consumeFoodItemAndMana(item);
                MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal2;
                cowAccessor.setStewEffects(effectHolder.getSuspiciousEffects());
                animal2.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
                break;
            }
            if (this.getMana() >= 12) continue;
            break;
        }
    }

    private void consumeFoodItemAndMana(ItemEntity itemEntity) {
        EntityHelper.shrinkItem(itemEntity);
        this.addMana(-12);
    }

    private static boolean isBrownMooshroomWithoutEffect(Animal animal) {
        MushroomCow mushroomCow;
        if (animal instanceof MushroomCow && (mushroomCow = (MushroomCow)animal).getVariant() == MushroomCow.MushroomType.BROWN) {
            MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
            return cowAccessor.getStewEffects() == null;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return this.getBlockPos().equals((Object)this.getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(this.getBlockPos(), 6);
    }

    @Override
    public int getMaxMana() {
        return 120;
    }

    @Override
    public int getColor() {
        return 13584665;
    }

    @NotNull
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.isShiftKeyDown()) {
            this.mode = this.mode.getNextMode();
            this.setChanged();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.mode = Mode.forName(cmp.getString(TAG_FEEDING_MODE));
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putString(TAG_FEEDING_MODE, this.mode.getSerializedName());
    }

    public static enum Mode implements StringRepresentable,
    Predicate<Animal>
    {
        FEED_ADULTS("feed_adults", Predicate.not(AgeableMob::isBaby)),
        FEED_BABIES("feed_babies", AgeableMob::isBaby),
        FEED_ALL("feed_all", animal -> true);

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        @NotNull
        private final String name;
        @NotNull
        private final Predicate<Animal> predicate;

        public static Mode forName(String name) {
            return (Mode)CODEC.byName(name, (Enum)FEED_ADULTS);
        }

        private Mode(String name, Predicate<Animal> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @Override
        public boolean test(Animal animal) {
            return this.predicate.test(animal);
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        @NotNull
        public Mode getNextMode() {
            Mode[] modes = Mode.values();
            int nextMode = this.ordinal() + 1;
            return modes[nextMode % modes.length];
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<PollidisiacBlockEntity> {
        public WandHud(PollidisiacBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String filter = I18n.get((String)("botaniamisc.pollidisiac." + ((PollidisiacBlockEntity)this.flower).getMode().getSerializedName()), (Object[])new Object[0]);
            int filterWidth = mc.font.width(filter);
            int filterTextStart = (mc.getWindow().getGuiScaledWidth() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.drawString(mc.font, filter, filterTextStart, centerY + 30, ((PollidisiacBlockEntity)this.flower).getColor());
        }
    }
}

