/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    protected OrechidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public OrechidBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.ORECHID, pos, state);
    }

    @Override
    public void tickFlower() {
        BlockPos coords;
        super.tickFlower();
        if (this.getLevel().isClientSide || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        if (this.getMana() >= this.getCost() && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null) {
            this.trySetRecipe(coords, this.findMatchingRecipe(coords));
        }
    }

    protected void playSound(BlockPos coords) {
        this.getLevel().playSound(null, coords, BotaniaSounds.orechid, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    private OrechidRecipe findMatchingRecipe(BlockPos coords) {
        BlockState input = this.level.getBlockState(coords);
        ArrayList<WeightedEntry.Wrapper> values = new ArrayList<WeightedEntry.Wrapper>();
        for (OrechidRecipe orechidRecipe : OrechidManager.getMatchingRecipes(this.getLevel().getRecipeManager(), this.getRecipeType(), input)) {
            values.add(WeightedEntry.wrap((Object)orechidRecipe, (int)orechidRecipe.getWeight(this.getLevel(), coords)));
        }
        return WeightedRandom.getRandomItem((RandomSource)this.getLevel().random, values).map(WeightedEntry.Wrapper::data).orElse(null);
    }

    private void trySetRecipe(BlockPos coords, @Nullable OrechidRecipe recipe) {
        if (recipe == null) {
            return;
        }
        BlockState state = recipe.getOutput(this.level, coords).pick(this.level.random);
        if (this.getLevel().setBlockAndUpdate(coords, state)) {
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.getLevel().levelEvent(2001, coords, Block.getId((BlockState)state));
            }
            this.playSound(coords);
            this.addMana(-this.getCost());
            this.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, coords);
            ServerLevel serverLevel = (ServerLevel)this.level;
            MinecraftServer server = serverLevel.getServer();
            recipe.getSuccessFunction().flatMap(cached -> cached.get(server.getFunctions())).ifPresent(command -> {
                CommandSourceStack context = server.getFunctions().getGameLoopSender().withLevel(serverLevel).withPosition(Vec3.atBottomCenterOf((Vec3i)coords));
                server.getFunctions().execute(command, context);
            });
            this.sync();
        }
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        Predicate<BlockState> matcher = this.getReplaceMatcher();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getEffectivePos().offset(-this.getRange(), -this.getRangeY(), -this.getRange()), (BlockPos)this.getEffectivePos().offset(this.getRange(), this.getRangeY(), this.getRange()))) {
            BlockState state = this.getLevel().getBlockState(pos);
            if (!matcher.test(state)) continue;
            possibleCoords.add(pos.immutable());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.getLevel().random.nextInt(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public RecipeType<? extends OrechidRecipe> getRecipeType() {
        return BotaniaRecipeTypes.ORECHID_TYPE;
    }

    public Predicate<BlockState> getReplaceMatcher() {
        return state -> !OrechidManager.getMatchingRecipes(this.getLevel().getRecipeManager(), this.getRecipeType(), state).isEmpty();
    }

    public int getCost() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 700 : 17500;
    }

    public int getDelay() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }
}

