/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class HyacidusBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 6;
    private static final int COST = 20;

    public HyacidusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.HYACIDUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide || this.redstoneSignal > 0) {
            return;
        }
        List entities = this.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(this.getEffectivePos()).inflate(6.0));
        for (LivingEntity entity : entities) {
            if (entity instanceof Player || entity.getEffect(MobEffects.POISON) != null || this.getMana() < 20 || entity.level().isClientSide || !entity.getType().is(EntityTypeTags.UNDEAD)) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, 0));
            this.addMana(-20);
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 9126799;
    }

    @Override
    public int getMaxMana() {
        return 180;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }
}

