/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.SpectranthemumBlockEntity;
import vazkii.botania.common.helper.DataComponentHelper;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.xplat.XplatAbstractions;

public class HopperhockBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    protected HopperhockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public HopperhockBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.HOPPERHOCK, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        BlockPos inPos = this.getBlockPos();
        BlockPos outPos = this.getEffectivePos();
        Predicate<ItemEntity> shouldPickup = item -> {
            if (XplatAbstractions.INSTANCE.preventsRemoteMovement((ItemEntity)item)) {
                return false;
            }
            ItemFlagsComponent flags = XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item);
            if (flags.spawnedByInWorldRecipe()) {
                return flags.timeCounter >= 5 + this.getModulatedDelay();
            }
            return DelayHelper.canInteractWith(this, item);
        };
        List items = this.getLevel().getEntitiesOfClass(ItemEntity.class, new AABB(inPos).inflate((double)range), shouldPickup);
        for (ItemEntity item2 : items) {
            ItemStack stack = item2.getItem();
            boolean priorityInv = false;
            int amountToPutIn = 0;
            Direction direction = null;
            for (Direction dir : Direction.values()) {
                boolean priority;
                Direction sideOfInventory;
                BlockPos inventoryPos = outPos.relative(dir);
                if (!XplatAbstractions.INSTANCE.hasInventory(this.level, inventoryPos, sideOfInventory = dir.getOpposite())) continue;
                List<ItemStack> filter = HopperhockBlockEntity.getFilterForInventory(this.getLevel(), inventoryPos, true);
                boolean canAccept = HopperhockBlockEntity.canAcceptItem(stack, filter, this.filterType);
                ItemStack simulate = XplatAbstractions.INSTANCE.insertToInventory(this.level, inventoryPos, sideOfInventory, stack, true);
                int inserted = stack.getCount() - simulate.getCount();
                boolean bl = canAccept = canAccept && inserted > 0;
                if (!canAccept) continue;
                boolean bl2 = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                priorityInv = priority;
                amountToPutIn = inserted;
                direction = dir;
            }
            if (direction == null || !item2.isAlive()) continue;
            SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item2, 3);
            InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.level, outPos.relative(direction), direction.getOpposite(), stack.split(amountToPutIn), false));
            EntityHelper.syncItem(item2);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public static boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack.isEmpty()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null || filterEntry.isEmpty()) continue;
                    anyFilter = true;
                    if (!DataComponentHelper.matchTagAndManaFullness(stack, filterEntry)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !HopperhockBlockEntity.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public static List<ItemStack> getFilterForInventory(Level level, BlockPos pos, boolean recursiveForDoubleChests) {
        BlockPos other;
        ChestType type;
        BlockState chest;
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests && (chest = level.getBlockState(pos)).hasProperty((Property)ChestBlock.TYPE) && (type = (ChestType)chest.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE && level.getBlockState(other = pos.relative(ChestBlock.getConnectedDirection((BlockState)chest))).is(chest.getBlock())) {
            filter.addAll(HopperhockBlockEntity.getFilterForInventory(level, other, false));
        }
        for (Direction dir : Direction.values()) {
            AABB aabb = new AABB(pos.relative(dir));
            List frames = level.getEntitiesOfClass(ItemFrame.class, aabb);
            for (ItemFrame frame : frames) {
                if (frame.getDirection() != dir) continue;
                filter.add(frame.getItem());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (player == null || player.isShiftKeyDown()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.getBlockPos(), 1);
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.filterType = cmp.getInt(TAG_FILTER_TYPE);
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x7F7F7F;
    }

    public static class Mini
    extends HopperhockBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.HOPPERHOCK_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<HopperhockBlockEntity> {
        public WandHud(HopperhockBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String filter = I18n.get((String)("botaniamisc.filter" + ((HopperhockBlockEntity)this.flower).filterType), (Object[])new Object[0]);
            int filterWidth = mc.font.width(filter);
            int filterTextStart = (mc.getWindow().getGuiScaledWidth() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.drawString(mc.font, filter, filterTextStart, centerY + 30, ((HopperhockBlockEntity)this.flower).getColor());
        }
    }
}

