/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.mixin.HurtByTargetGoalAccessor;
import vazkii.botania.mixin.MobAccessor;

public class HeiseiDreamBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int COST = 100;

    public HeiseiDreamBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.HEISEI_DREAM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            return;
        }
        List mobs = this.getLevel().getEntitiesOfClass(Mob.class, new AABB(this.getEffectivePos()).inflate(5.0), (Predicate)Predicates.instanceOf(Enemy.class));
        if (mobs.size() > 1 && this.getMana() >= 100) {
            for (Mob mob : mobs) {
                if (!HeiseiDreamBlockEntity.brainwashEntity(mob, mobs)) continue;
                this.addMana(-100);
                this.sync();
                break;
            }
        }
    }

    public static boolean brainwashEntity(Mob entity, List<Mob> mobs) {
        LivingEntity target = entity.getTarget();
        boolean did = false;
        if (!(target instanceof Enemy)) {
            Mob newTarget;
            while ((newTarget = mobs.get(entity.level().random.nextInt(mobs.size()))) == entity) {
            }
            entity.setTarget(null);
            GoalSelector targetSelector = ((MobAccessor)entity).getTargetSelector();
            for (WrappedGoal entry : targetSelector.getAvailableGoals()) {
                Goal goal = entry.getGoal();
                if (!(goal instanceof HurtByTargetGoal)) continue;
                HurtByTargetGoal goal2 = (HurtByTargetGoal)goal;
                Object[] ignoreClasses = ((HurtByTargetGoalAccessor)goal2).getIgnoreDamageClasses();
                Arrays.fill(ignoreClasses, Void.TYPE);
                targetSelector.removeGoal((Goal)goal2);
                targetSelector.addGoal(-1, (Goal)goal2);
                break;
            }
            entity.setLastHurtByMob((LivingEntity)newTarget);
            did = true;
        }
        return did;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 16720285;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }
}

