/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.GrowingPlantBodyBlockMixin;
import vazkii.botania.xplat.BotaniaConfig;

public class AgricarnationBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;
    private static final int MANA_COST = 5;
    private static final float BONEMEAL_SUCCESS_CHANCE = 0.5f;

    protected AgricarnationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AgricarnationBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.AGRICARNATION, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.getEffectivePos().getX() + serverLevel.random.nextInt(range * 2 + 1) - range;
            int z = this.getEffectivePos().getZ() + serverLevel.random.nextInt(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                BonemealableBlock bonemealableBlock;
                Optional<BlockPos> headPos;
                int y = this.getEffectivePos().getY() + i;
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = serverLevel.getBlockState(pos);
                if (state.isAir()) continue;
                Block block = state.getBlock();
                if (block instanceof GrowingPlantBodyBlock && (headPos = ((GrowingPlantBodyBlockMixin)block).botania_getHeadPos((BlockGetter)serverLevel, pos, block)).isPresent()) {
                    pos = headPos.get();
                }
                if (!this.isPlant((Level)serverLevel, pos, state, block) || this.getMana() <= 5) continue;
                this.addMana(-5);
                if (state.is(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL) && block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)serverLevel, pos, state)) {
                    if (serverLevel.random.nextFloat() < 0.5f && bonemealableBlock.isBonemealSuccess((Level)serverLevel, serverLevel.random, pos, state)) {
                        bonemealableBlock.performBonemeal(serverLevel, serverLevel.random, pos, state);
                    }
                } else {
                    state.randomTick(serverLevel, pos, serverLevel.random);
                }
                if (BotaniaConfig.common().blockBreakParticles()) {
                    serverLevel.levelEvent(2011, pos, 6 + serverLevel.random.nextInt(4));
                }
                serverLevel.playSound(null, (double)x, (double)y, (double)z, BotaniaSounds.agricarnation, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(Level level, BlockPos pos, BlockState state, Block block) {
        BonemealableBlock bonemealableBlock;
        if (state.is(BotaniaTags.Blocks.AGRICARNATION_GROWTH_EXCLUDED) || (block instanceof SpreadingSnowyDirtBlock || block instanceof NyliumBlock) && !state.is(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE)) {
            return false;
        }
        boolean couldApplyBonemeal = block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, state);
        boolean isTargetCandidate = couldApplyBonemeal || block instanceof BushBlock || state.is(BotaniaTags.Blocks.AGRICARNATION_GROWTH_CANDIDATE);
        boolean acceptsGrowthBoost = state.isRandomlyTicking() || couldApplyBonemeal && state.is(BotaniaTags.Blocks.AGRICARNATION_APPLY_BONEMEAL);
        return isTargetCandidate && acceptsGrowthBoost;
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends AgricarnationBlockEntity {
        public Mini(BlockPos pos, BlockState state) {
            super(BotaniaFlowerBlocks.AGRICARNATION_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }
    }
}

