/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower;

import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.xplat.BotaniaConfig;

public class PureDaisyBlockEntity
extends SpecialFlowerBlockEntity {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int RECIPE_COMPLETE_EVENT = 0;
    private static final BlockPos[] POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    private int positionAt = 0;
    private final int[] prevTicksRemaining = new int[POSITIONS.length];
    private final int[] ticksRemaining = new int[POSITIONS.length];

    public PureDaisyBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.PURE_DAISY, pos, state);
        Arrays.fill(this.prevTicksRemaining, -1);
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if (this.ticksRemaining[i] <= 0) continue;
                BlockPos coords = this.getEffectivePos().offset((Vec3i)POSITIONS[i]);
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), 1.0f, 1.0f, 1.0f, 5);
                this.level.addParticle((ParticleOptions)data, (double)coords.getX() + Math.random(), (double)coords.getY() + Math.random(), (double)coords.getZ() + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos atCoords = POSITIONS[this.positionAt];
        BlockPos coords = this.getEffectivePos().offset((Vec3i)atCoords);
        Level world = this.getLevel();
        if (!world.isEmptyBlock(coords)) {
            world.getProfiler().push("findRecipe");
            PureDaisyRecipe recipe = this.findRecipe(coords);
            world.getProfiler().pop();
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    BlockState stateToPlace;
                    this.ticksRemaining[this.positionAt] = -1;
                    BlockState recipeOutputState = recipe.getOutput().pick(this.level.random);
                    if (recipe.isCopyInputProperties()) {
                        BlockState stateToReplace = this.level.getBlockState(atCoords);
                        stateToPlace = recipeOutputState.getBlock().withPropertiesOf(stateToReplace);
                    } else {
                        stateToPlace = recipeOutputState;
                    }
                    if (this.getLevel().setBlockAndUpdate(coords, stateToPlace)) {
                        if (BotaniaConfig.common().blockBreakParticles()) {
                            this.getLevel().levelEvent(2001, coords, Block.getId((BlockState)stateToPlace));
                        }
                        this.getLevel().gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, coords);
                        this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, this.positionAt);
                        ServerLevel serverLevel = (ServerLevel)this.level;
                        MinecraftServer server = serverLevel.getServer();
                        recipe.getSuccessFunction().flatMap(cached -> cached.get(server.getFunctions())).ifPresent(command -> {
                            CommandSourceStack context = server.getFunctions().getGameLoopSender().withLevel(serverLevel).withPosition(Vec3.atBottomCenterOf((Vec3i)coords));
                            server.getFunctions().execute(command, context);
                        });
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        if (!Arrays.equals(this.ticksRemaining, this.prevTicksRemaining)) {
            this.setChanged();
            this.sync();
            System.arraycopy(this.ticksRemaining, 0, this.prevTicksRemaining, 0, POSITIONS.length);
        }
    }

    @Nullable
    private PureDaisyRecipe findRecipe(BlockPos coords) {
        BlockState state = this.getLevel().getBlockState(coords);
        for (RecipeHolder<PureDaisyRecipe> recipe : BotaniaRecipeTypes.getRecipes(this.level, BotaniaRecipeTypes.PURE_DAISY_TYPE)) {
            PureDaisyRecipe daisyRecipe;
            Recipe recipe2 = recipe.value();
            if (!(recipe2 instanceof PureDaisyRecipe) || !(daisyRecipe = (PureDaisyRecipe)recipe2).matches(this.getLevel(), coords, state)) continue;
            return daisyRecipe;
        }
        return null;
    }

    public boolean triggerEvent(int type, int param) {
        switch (type) {
            case 0: {
                if (this.getLevel().isClientSide) {
                    BlockPos coords = this.getEffectivePos().offset((Vec3i)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.getX() + Math.random();
                        double y = (double)coords.getY() + Math.random() + 0.5;
                        double z = (double)coords.getZ() + Math.random();
                        WispParticleData data = WispParticleData.wisp((float)Math.random() / 2.0f, 1.0f, 1.0f, 1.0f);
                        this.getLevel().addParticle((ParticleOptions)data, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
        }
        return super.triggerEvent(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readFromPacketNBT(cmp, registries);
        this.positionAt = cmp.getInt(TAG_POSITION);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            this.ticksRemaining[i] = cmp.getInt(TAG_TICKS_REMAINING + i);
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writeToPacketNBT(cmp, registries);
        cmp.putInt(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.putInt(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }
}

