/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SeedsBehavior
extends OptionalDispenseItemBehavior {
    private final Block block;

    public SeedsBehavior(Block block) {
        this.block = block;
    }

    @NotNull
    public ItemStack execute(BlockSource source, ItemStack stack) {
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = source.pos().relative(facing);
        ServerLevel world = source.level();
        this.setSuccess(false);
        if (world.isEmptyBlock(pos) && this.block.defaultBlockState().canSurvive((LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, this.block.defaultBlockState());
            stack.shrink(1);
            this.setSuccess(true);
        }
        return stack;
    }
}

