/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.ManaPoolMinecartEntity;

public class ManaPoolMinecartBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

    @NotNull
    public ItemStack execute(BlockSource source, ItemStack stack) {
        double yOffset;
        RailShape railShape;
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        ServerLevel world = source.level();
        double x = source.center().x() + (double)direction.getStepX() * 1.125;
        double y = Math.floor(source.center().y()) + (double)direction.getStepY();
        double z = source.center().z() + (double)direction.getStepZ() * 1.125;
        BlockPos blockpos = source.pos().relative(direction);
        BlockState blockState = world.getBlockState(blockpos);
        RailShape railShape2 = railShape = blockState.getBlock() instanceof BaseRailBlock ? (RailShape)blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
        if (blockState.is(BlockTags.RAILS)) {
            yOffset = railShape.isAscending() ? 0.6 : 0.1;
        } else {
            if (!blockState.isAir() || !world.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                return this.behaviourDefaultDispenseItem.dispense(source, stack);
            }
            BlockState blockStateBelow = world.getBlockState(blockpos.below());
            RailShape railShapeBelow = blockStateBelow.getBlock() instanceof BaseRailBlock ? (RailShape)blockStateBelow.getValue(((BaseRailBlock)blockStateBelow.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            yOffset = direction != Direction.DOWN && railShapeBelow.isAscending() ? -0.4 : -0.9;
        }
        ManaPoolMinecartEntity minecart = new ManaPoolMinecartEntity((Level)world, x, y + yOffset, z);
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            minecart.setCustomName(stack.getHoverName());
        }
        world.addFreshEntity((Entity)minecart);
        stack.shrink(1);
        return stack;
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1000, source.pos(), 0);
    }
}

