/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.material.EnderAirItem;

public class EnderAirBottlingBehavior
extends OptionalDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();
    private final DispenseItemBehavior parent;

    public EnderAirBottlingBehavior(DispenseItemBehavior parent) {
        this.parent = parent;
    }

    protected void playSound(BlockSource source) {
        if (this.isSuccess()) {
            super.playSound(source);
        }
    }

    protected void playAnimation(BlockSource source, Direction facingIn) {
        if (this.isSuccess()) {
            super.playAnimation(source, facingIn);
        }
    }

    private static boolean pickupInEnd(Level world, BlockPos facingPos) {
        return world.dimension() == Level.END && world.isEmptyBlock(facingPos) && world.isEmptyBlock(facingPos.above()) && EnderAirItem.isClearFromDragonBreath(world, new AABB(facingPos).inflate(2.0));
    }

    @NotNull
    protected ItemStack execute(BlockSource source, @NotNull ItemStack stack) {
        BlockPos blockpos;
        ServerLevel world = source.level();
        if (EnderAirBottlingBehavior.pickupInEnd((Level)world, blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING))) || EnderAirItem.pickupFromEntity((Level)world, new AABB(blockpos))) {
            this.setSuccess(true);
            return this.defaultBehaviour.consumeWithRemainder(source, stack, new ItemStack((ItemLike)BotaniaItems.enderAirBottle));
        }
        this.setSuccess(false);
        return this.parent.dispense(source, stack);
    }
}

