/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaFlameBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = ManaFlameBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public ManaFlameBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (XplatAbstractions.INSTANCE.gogLoaded() && stack.is(ItemTags.SAPLINGS) && !InventoryHelper.containsType(player.getInventory(), BotaniaItems.lexicon)) {
            if (!level.isClientSide) {
                stack.shrink(1);
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)BotaniaItems.lexicon));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof ManaFlameBlockEntity) {
            float v;
            float b;
            float g;
            ManaFlameBlockEntity flame = (ManaFlameBlockEntity)te;
            int color = flame.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            double luminance = 0.2126 * (double)r + 0.7152 * (double)(g = (float)(color >> 8 & 0xFF) / 255.0f) + 0.0722 * (double)(b = (float)(color & 0xFF) / 255.0f);
            if (luminance < (double)(v = 0.1f)) {
                r += (float)Math.random() * 0.125f;
                g += (float)Math.random() * 0.125f;
                b += (float)Math.random() * 0.125f;
            }
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)pos.getX() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)pos.getY() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)pos.getZ() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.03f + (float)Math.random() * 0.015f;
            WispParticleData data = WispParticleData.wisp(s, r, g, b, 1.0f);
            world.addParticle((ParticleOptions)data, x, y, z, 0.0, (double)m, 0.0);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaFlameBlockEntity(pos, state);
    }
}

