/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class BuriedPetalBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<BuriedPetalBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StringRepresentable.fromEnum(DyeColor::values).fieldOf("color").forGetter(o -> o.color), (App)BuriedPetalBlock.propertiesCodec()).apply((Applicative)instance, BuriedPetalBlock::new));
    private static final VoxelShape SHAPE = BuriedPetalBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.6, (double)16.0);
    public final DyeColor color;

    protected MapCodec<BuriedPetalBlock> codec() {
        return CODEC;
    }

    public BuriedPetalBlock(DyeColor color, BlockBehaviour.Properties builder) {
        super(builder);
        this.color = color;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        SparkleParticleData data = SparkleParticleData.noClip(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
        world.addParticle((ParticleOptions)data, (double)pos.getX() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.getY() + 0.1 + (double)rand.nextFloat() * 0.1, (double)pos.getZ() + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return world.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.isValidBonemealTarget((LevelReader)world, pos, state);
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = BotaniaBlocks.getDoubleFlower(this.color);
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)block.defaultBlockState(), (BlockPos)pos, (int)3);
        }
    }
}

