/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.red_string;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Bound;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public abstract class RedStringBlockEntity
extends BotaniaBlockEntity
implements Bound {
    private BlockPos binding;

    protected RedStringBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void commonTick(Level level, BlockPos pos_, BlockState state, RedStringBlockEntity self) {
        Direction dir = self.getOrientation();
        int range = self.getRange();
        BlockPos currBinding = self.getBinding();
        self.setBinding(null);
        for (int i = 0; i < range; ++i) {
            BlockEntity tile;
            if (level.isEmptyBlock(pos_ = pos_.relative(dir)) || (tile = level.getBlockEntity(pos_)) instanceof RedStringBlockEntity || !self.acceptBlock(pos_)) continue;
            self.setBinding(pos_);
            if (!Objects.equals(currBinding, pos_)) {
                self.onBound(pos_);
            }
            return;
        }
        if (!level.isClientSide && !Objects.equals(currBinding, self.binding)) {
            self.onBound(self.binding);
        }
    }

    public int getRange() {
        return 8;
    }

    public abstract boolean acceptBlock(BlockPos var1);

    public void onBound(@Nullable BlockPos pos) {
    }

    @Override
    @Nullable
    public BlockPos getBinding() {
        return this.binding;
    }

    public void setBinding(BlockPos binding) {
        this.binding = binding;
    }

    public Direction getOrientation() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    @Nullable
    public BlockEntity getTileAtBinding() {
        BlockPos binding = this.getBinding();
        return binding == null || this.level == null ? null : this.level.getBlockEntity(binding);
    }

    public BlockState getStateAtBinding() {
        BlockPos binding = this.getBinding();
        return binding == null ? Blocks.AIR.defaultBlockState() : this.level.getBlockState(binding);
    }

    public Block getBlockAtBinding() {
        return this.getStateAtBinding().getBlock();
    }
}

