/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.KeyLocked;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolBlockEntity
extends BotaniaBlockEntity
implements ManaPool,
KeyLocked,
SparkAttachable,
ThrottledPacket,
Wandable {
    public static final int PARTICLE_COLOR = 50943;
    public static final float PARTICLE_COLOR_BLUE = 1.0f;
    public static final float PARTICLE_COLOR_GREEN = 0.7764706f;
    public static final float PARTICLE_COLOR_RED = 0.0f;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private static final int DRAIN_EFFECT_EVENT = 2;
    private static final float CHARGING_GRAVITY = 0.003f;
    private boolean outputting = false;
    private Optional<DyeColor> legacyColor = Optional.empty();
    private int mana;
    private int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;
    private final Int2ObjectMap<MutableInt> chargingParticles = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MutableInt> drainingParticles = new Int2ObjectOpenHashMap();

    public ManaPoolBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.POOL, pos, state);
    }

    @Override
    public boolean isFull() {
        BlockState stateBelow = this.level.getBlockState(this.worldPosition.below());
        return !stateBelow.is(BotaniaBlocks.manaVoid) && this.getCurrentMana() >= this.getMaxMana();
    }

    @Override
    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.getMaxMana()));
        if (old != this.mana) {
            this.setChanged();
            this.markDispatchable();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public ManaInfusionRecipe getMatchingRecipe(@NotNull ItemStack stack, @NotNull BlockState state) {
        ArrayList<ManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<ManaInfusionRecipe>();
        ArrayList<ManaInfusionRecipe> matchingCatRecipes = new ArrayList<ManaInfusionRecipe>();
        for (RecipeHolder<ManaInfusionRecipe> recipe : BotaniaRecipeTypes.getRecipes(this.level, BotaniaRecipeTypes.MANA_INFUSION_TYPE)) {
            if (!((ManaInfusionRecipe)recipe.value()).matches(stack)) continue;
            if (((ManaInfusionRecipe)recipe.value()).getRecipeCatalyst() == null) {
                matchingNonCatRecipes.add((ManaInfusionRecipe)recipe.value());
                continue;
            }
            if (!((ManaInfusionRecipe)recipe.value()).getRecipeCatalyst().test(state)) continue;
            matchingCatRecipes.add((ManaInfusionRecipe)recipe.value());
        }
        return !matchingCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(ItemEntity item) {
        if (this.level.isClientSide || !item.isAlive() || item.getItem().isEmpty()) {
            return false;
        }
        ItemStack stack = item.getItem();
        Item item2 = stack.getItem();
        if (item2 instanceof ManaDissolvable) {
            ManaDissolvable dissolvable = (ManaDissolvable)item2;
            dissolvable.onDissolveTick(this, item);
        }
        if (XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).manaInfusionSpawned) {
            return false;
        }
        ManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.level.getBlockState(this.worldPosition.below()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                ItemStack output = recipe.getRecipeOutput(this.level.registryAccess(), stack);
                EntityHelper.shrinkItem(item);
                item.setOnGround(false);
                ItemEntity outputItem = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).manaInfusionSpawned = true;
                this.level.addFreshEntity((Entity)outputItem);
                this.craftingEffect(true);
                return true;
            }
        }
        return false;
    }

    public void craftingEffect(boolean playSound) {
        if (playSound && this.soundTicks == 0) {
            this.level.playSound(null, this.worldPosition, BotaniaSounds.manaPoolCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.level.gameEvent(null, (Holder)GameEvent.BLOCK_ACTIVATE, this.getBlockPos());
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 0);
    }

    public boolean triggerEvent(int event, int param) {
        switch (event) {
            case 0: {
                if (this.level.isClientSide) {
                    for (int i2 = 0; i2 < 25; ++i2) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.level.addParticle((ParticleOptions)data, (double)this.worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.level.isClientSide && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.chargingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                return true;
            }
            case 2: {
                if (this.level.isClientSide && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.drainingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                return true;
            }
        }
        return super.triggerEvent(event, param);
    }

    private void initManaCapAndNetwork() {
        if (this.getMaxMana() == -1) {
            int n = this.manaCap = ((ManaPoolBlock)this.getBlockState().getBlock()).variant == ManaPoolBlock.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this.level, this) && !this.isRemoved()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, ManaPoolBlockEntity self) {
        self.initManaCapAndNetwork();
        double particleChance = 1.0 - (double)self.getCurrentMana() / (double)self.getMaxMana() * 0.1;
        if (Math.random() > particleChance) {
            WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, 0.0f, 0.7764706f, 1.0f, 2.0f);
            level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + 0.3 + Math.random() * 0.5, (double)worldPosition.getY() + 0.6 + Math.random() * 0.25, (double)worldPosition.getZ() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
        if (self.getCurrentMana() == 0) {
            self.chargingParticles.clear();
        } else {
            ManaPoolBlockEntity.displayChargingParticles(level, worldPosition, self, self.chargingParticles, true);
        }
        ManaPoolBlockEntity.displayChargingParticles(level, worldPosition, self, self.drainingParticles, false);
    }

    private static void displayChargingParticles(Level level, BlockPos worldPosition, ManaPoolBlockEntity self, Int2ObjectMap<MutableInt> particles, boolean charging) {
        int bellowCount = charging ? ManaPoolBlockEntity.getBellowCount(level, worldPosition, self) : 0;
        float relativeMana = (float)self.getCurrentMana() / (float)self.getMaxMana();
        ObjectIterator particlesIterator = particles.int2ObjectEntrySet().iterator();
        while (particlesIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)particlesIterator.next();
            int ticksRemaining = ((MutableInt)entry.getValue()).decrementAndGet();
            if (ticksRemaining % 2 == 0) {
                int encodedPos = entry.getIntKey();
                Vec3 itemPosRelBase = ManaPoolBlockEntity.decodeRelativeItemPosition(encodedPos, relativeMana);
                if (charging) {
                    for (int i = 0; i <= bellowCount; ++i) {
                        Vec3 itemPosRel = ManaPoolBlockEntity.randomizeItemPos(itemPosRelBase);
                        Vec3 poolPosRel = new Vec3(0.1 + 0.8 * Math.random(), 0.1 + 0.4 * (double)relativeMana, 0.1 + 0.8 * Math.random());
                        ManaPoolBlockEntity.addManaFlowParticle(level, worldPosition, poolPosRel, itemPosRel);
                    }
                } else {
                    Vec3 itemPosRel = ManaPoolBlockEntity.randomizeItemPos(itemPosRelBase);
                    Vec3 poolPosRel = new Vec3(0.05 + 0.9 * Math.random(), 0.35 * (double)relativeMana, 0.05 + 0.9 * Math.random());
                    ManaPoolBlockEntity.addManaFlowParticle(level, worldPosition, itemPosRel, poolPosRel);
                }
            }
            if (ticksRemaining > 0) continue;
            particlesIterator.remove();
        }
    }

    @NotNull
    private static Vec3 randomizeItemPos(Vec3 itemPosRelBase) {
        return itemPosRelBase.add(0.1 * Math.random() - 0.05, 0.1 * Math.random() + 0.25, 0.1 * Math.random() - 0.05);
    }

    private static int getBellowCount(Level level, BlockPos worldPosition, ManaPoolBlockEntity self) {
        int bellowCount = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BellowsBlockEntity bellows;
            BlockEntity tile = level.getBlockEntity(worldPosition.relative(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellows = (BellowsBlockEntity)tile).getLinkedTile() != self) continue;
            ++bellowCount;
        }
        return bellowCount;
    }

    private static void addManaFlowParticle(Level level, BlockPos worldPosition, Vec3 startPos, Vec3 endPos) {
        double maxHeight = Math.max(startPos.y, endPos.y) - endPos.y + 0.05 * Math.random();
        Vec3 horizontalDiff = new Vec3(endPos.x - startPos.x, 0.0, endPos.z - startPos.z);
        double horizontalDistance = horizontalDiff.horizontalDistance();
        Vec3 horizontalDir = horizontalDiff.scale(1.0 / horizontalDistance);
        double startHeight = startPos.y - endPos.y;
        double vY0Squared = (double)0.006f * (maxHeight - startHeight);
        double vY0 = Math.sqrt(vY0Squared);
        double lifetime = (vY0 + Math.sqrt(vY0Squared + (double)0.006f * startHeight)) / (double)0.003f;
        double vX0 = horizontalDistance / lifetime;
        Vec3 v0 = horizontalDir.scale(vX0).with(Direction.Axis.Y, vY0);
        WispParticleData data = WispParticleData.wisp(0.1f, 0.0f, 0.7764706f, 1.0f, (float)(0.025 * lifetime), 0.003f).withNoClip(true);
        level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + startPos.x, (double)worldPosition.getY() + startPos.y, (double)worldPosition.getZ() + startPos.z, v0.x, v0.y, v0.z);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, ManaPoolBlockEntity self) {
        if (self.legacyColor.isPresent()) {
            self.setColor(self.legacyColor);
            self.legacyColor = Optional.empty();
        }
        self.initManaCapAndNetwork();
        boolean wasDoingTransfer = self.isDoingTransfer;
        self.isDoingTransfer = false;
        if (self.soundTicks > 0) {
            --self.soundTicks;
        }
        if (self.sendPacket && self.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            self.sendPacket = false;
        }
        List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(worldPosition));
        for (ItemEntity item : items) {
            if (!item.isAlive()) continue;
            ItemStack stack = item.getItem();
            ManaItem mana = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.isEmpty() || mana == null || (!self.outputting || !mana.canReceiveManaFromPool(self)) && (self.outputting || !mana.canExportManaToPool(self))) continue;
            boolean didSomething = false;
            int bellowCount = self.outputting ? ManaPoolBlockEntity.getBellowCount(level, worldPosition, self) : 0;
            int transfRate = 1000 * (bellowCount + 1);
            if (self.outputting) {
                if (self.canSpare) {
                    if (self.getCurrentMana() > 0 && mana.getMana() < mana.getMaxMana()) {
                        didSomething = true;
                    }
                    manaVal = Math.min(transfRate, Math.min(self.getCurrentMana(), mana.getMaxMana() - mana.getMana()));
                    mana.addMana(manaVal);
                    self.receiveMana(-manaVal);
                }
            } else if (self.canAccept) {
                if (mana.getMana() > 0 && !self.isFull()) {
                    didSomething = true;
                }
                if ((manaVal = Math.min(transfRate, Math.min(self.getMaxMana() - self.getCurrentMana(), mana.getMana()))) == 0 && self.level.getBlockState(worldPosition.below()).is(BotaniaBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana());
                }
                mana.addMana(-manaVal);
                self.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && self.ticks % 10 == 0) {
                level.blockEvent(worldPosition, state.getBlock(), self.outputting ? 1 : 2, ManaPoolBlockEntity.encodeRelativeItemPosition(worldPosition, item));
            }
            EntityHelper.syncItem(item);
            self.isDoingTransfer = self.outputting;
        }
        if (self.isDoingTransfer) {
            ++self.ticksDoingTransfer;
        } else {
            self.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        }
        ++self.ticks;
    }

    private static int encodeRelativeItemPosition(BlockPos worldPosition, ItemEntity item) {
        double relX = Mth.clamp((double)(item.position().x() - (double)worldPosition.getX()), (double)0.0, (double)1.0);
        double relY = Mth.clamp((double)(0.125 + 0.875 * (item.position().y() - (double)worldPosition.getY())), (double)0.125, (double)0.9);
        double relZ = Mth.clamp((double)(item.position().z() - (double)worldPosition.getZ()), (double)0.0, (double)1.0);
        int compressedX = (int)Math.round(7.0 * relX);
        int compressedY = 4 - Mth.ceillog2((int)(14 - (int)(14.0 * relY)));
        int compressedZ = (int)Math.round(7.0 * relZ);
        return compressedX | compressedY << 3 | compressedZ << 5;
    }

    private static Vec3 decodeRelativeItemPosition(int param, float relativeMana) {
        int compressedX = param & 7;
        int compressedY = param >> 3 & 3;
        int compressedZ = param >> 5 & 7;
        double relX = (double)compressedX / 7.0;
        double relY = 1.0 - 0.875 / (double)(1 << compressedY);
        double relZ = (double)compressedZ / 7.0;
        return new Vec3(relX, Math.max(relY, 0.5 * (double)relativeMana), relZ);
    }

    @Override
    public void writePacketNBT(@NotNull CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_MANA, this.getCurrentMana());
        cmp.putBoolean(TAG_OUTPUTTING, this.outputting);
        cmp.putInt(TAG_MANA_CAP, this.getMaxMana());
        cmp.putBoolean(TAG_CAN_ACCEPT, this.canAccept);
        cmp.putBoolean(TAG_CAN_SPARE, this.canSpare);
        cmp.putString(TAG_INPUT_KEY, this.inputKey);
        cmp.putString(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.mana = cmp.getInt(TAG_MANA);
        this.outputting = cmp.getBoolean(TAG_OUTPUTTING);
        if (cmp.contains("color")) {
            DyeColor color = DyeColor.byId((int)cmp.getInt("color"));
            this.legacyColor = color != DyeColor.WHITE ? Optional.of(color) : Optional.empty();
        }
        if (cmp.contains(TAG_MANA_CAP)) {
            this.manaCap = cmp.getInt(TAG_MANA_CAP);
        }
        if (cmp.contains(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.getBoolean(TAG_CAN_ACCEPT);
        }
        if (cmp.contains(TAG_CAN_SPARE)) {
            this.canSpare = cmp.getBoolean(TAG_CAN_SPARE);
        }
        if (cmp.contains(TAG_INPUT_KEY)) {
            this.inputKey = cmp.getString(TAG_INPUT_KEY);
        }
        if (cmp.contains(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.getString(TAG_OUTPUT_KEY);
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.isShiftKeyDown()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof ManaPoolBlock) {
            ManaPoolBlock pool = (ManaPoolBlock)block;
            return pool.variant == ManaPoolBlock.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public int getMaxMana() {
        return this.manaCap;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition.above()), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.getMaxMana() - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.level.getBlockState(this.worldPosition.below()).is(BotaniaBlocks.manaVoid)) {
            return this.getMaxMana();
        }
        return 0;
    }

    @Override
    public Optional<DyeColor> getColor() {
        return ((BotaniaStateProperties.OptionalDyeColor)((Object)this.getBlockState().getValue(BotaniaStateProperties.OPTIONAL_DYE_COLOR))).toDyeColor();
    }

    @Override
    public void setColor(Optional<DyeColor> color) {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)((Object)BotaniaStateProperties.OptionalDyeColor.fromOptionalDyeColor(color))));
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPoolBlockEntity pool;

        public WandHud(ManaPoolBlockEntity pool) {
            this.pool = pool;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.getBlockState().getBlock());
            String name = poolStack.getHoverName().getString();
            int centerX = mc.getWindow().getGuiScaledWidth() / 2;
            int centerY = mc.getWindow().getGuiScaledHeight() / 2;
            int width = Math.max(102, mc.font.width(name)) + 4;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 48);
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, this.pool.getCurrentMana(), this.pool.getMaxMana(), name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.outputting ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, centerX - 11, centerY + 30, arrowU, arrowV, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative(tablet);
            gui.renderItem(tablet, centerX - 31, centerY + 30);
            gui.renderItem(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

