/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class CorporeaRetainerBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final String TAG_RETAIN_MISSING = "retainMissing";
    private static final Map<ResourceLocation, Function<CompoundTag, ? extends CorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<ResourceLocation, Function<CompoundTag, ? extends CorporeaRequestMatcher>>();
    private static final Map<Class<? extends CorporeaRequestMatcher>, ResourceLocation> corporeaMatcherSerializers = new ConcurrentHashMap<Class<? extends CorporeaRequestMatcher>, ResourceLocation>();
    private BlockPos requestPos = ManaBurst.NO_SOURCE;
    @Nullable
    private CorporeaRequestMatcher request;
    private int requestCount;
    private boolean retainMissing = false;

    public CorporeaRetainerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_RETAINER, pos, state);
    }

    public void remember(BlockPos pos, CorporeaRequestMatcher request, int count, int missing) {
        this.requestPos = pos;
        this.request = request;
        this.requestCount = this.retainMissing ? missing : count;
        this.setChanged();
    }

    public void forget() {
        this.request = null;
        this.requestCount = 0;
    }

    public int getComparatorValue() {
        return CorporeaHelper.instance().signalStrengthForRequestSize(this.requestCount);
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        BlockEntity te;
        if (!this.hasPendingRequest()) {
            return;
        }
        CorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(this.level, this.requestPos);
        if (spark != null && (te = spark.getSparkNode().getWorld().getBlockEntity(spark.getSparkNode().getPos())) instanceof CorporeaRequestor) {
            CorporeaRequestor requestor = (CorporeaRequestor)te;
            requestor.doCorporeaRequest(this.request, this.requestCount, spark, null);
            this.forget();
            this.setChanged();
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        ResourceLocation reqType;
        super.writePacketNBT(cmp, registries);
        cmp.putInt(TAG_REQUEST_X, this.requestPos.getX());
        cmp.putInt(TAG_REQUEST_Y, this.requestPos.getY());
        cmp.putInt(TAG_REQUEST_Z, this.requestPos.getZ());
        ResourceLocation resourceLocation = reqType = this.request != null ? corporeaMatcherSerializers.get(this.request.getClass()) : null;
        if (reqType != null) {
            cmp.putString(TAG_REQUEST_TYPE, reqType.toString());
            this.request.writeToNBT(cmp);
            cmp.putInt(TAG_REQUEST_COUNT, this.requestCount);
        }
        cmp.putBoolean(TAG_RETAIN_MISSING, this.retainMissing);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readPacketNBT(cmp, registries);
        int x = cmp.getInt(TAG_REQUEST_X);
        int y = cmp.getInt(TAG_REQUEST_Y);
        int z = cmp.getInt(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        ResourceLocation reqType = ResourceLocation.tryParse((String)cmp.getString(TAG_REQUEST_TYPE));
        this.request = reqType != null && corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.getInt(TAG_REQUEST_COUNT);
        this.retainMissing = cmp.getBoolean(TAG_RETAIN_MISSING);
    }

    public static <T extends CorporeaRequestMatcher> void addCorporeaRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundTag, T> deserializer) {
        corporeaMatcherSerializers.put(clazz, id);
        corporeaMatcherDeserializers.put(id, deserializer);
    }

    @Override
    public boolean onUsedByWand(Player player, ItemStack stack, Direction side) {
        if (!this.level.isClientSide) {
            this.retainMissing = !this.retainMissing;
            this.setChanged();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements WandHUD {
        private final CorporeaRetainerBlockEntity retainer;

        public WandHud(CorporeaRetainerBlockEntity retainer) {
            this.retainer = retainer;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String mode = I18n.get((String)("botaniamisc.retainer." + (this.retainer.retainMissing ? "retain_missing" : "retain_all")), (Object[])new Object[0]);
            int strWidth = mc.font.width(mode);
            int x = (mc.getWindow().getGuiScaledWidth() - strWidth) / 2;
            int y = mc.getWindow().getGuiScaledHeight() / 2 + 8;
            RenderHelper.renderHUDBox(gui, x - 2, y, x + strWidth + 2, y + 12);
            gui.drawString(mc.font, mode, x, y + 2, ChatFormatting.WHITE.getColor().intValue());
        }
    }
}

