/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaRequestor;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class CorporeaFunnelBlockEntity
extends BaseCorporeaBlockEntity
implements CorporeaRequestor {
    public CorporeaFunnelBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CORPOREA_FUNNEL, pos, state);
    }

    public void doRequest() {
        ItemStack stack;
        List<ItemStack> filter;
        CorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !(filter = this.getFilter()).isEmpty() && !(stack = filter.get(this.level.random.nextInt(filter.size()))).isEmpty()) {
            CorporeaRequestMatcher matcher = CorporeaHelper.instance().createMatcher(stack, true);
            this.doCorporeaRequest(matcher, stack.getCount(), spark, null);
        }
    }

    public List<ItemStack> getFilter() {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        int[] rotationToStackSize = new int[]{1, 2, 4, 8, 16, 32, 48, 64};
        for (Direction dir : Direction.values()) {
            List frames = this.level.getEntitiesOfClass(ItemFrame.class, new AABB(this.worldPosition.relative(dir)));
            for (ItemFrame frame : frames) {
                ItemStack stack;
                Direction orientation = frame.getDirection();
                if (orientation != dir || (stack = frame.getItem()).isEmpty()) continue;
                ItemStack copy = stack.copyWithCount(rotationToStackSize[frame.getRotation()]);
                filter.add(copy);
            }
        }
        return filter;
    }

    @Override
    public void doCorporeaRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, @Nullable LivingEntity entity) {
        BlockPos invPos = this.getInvPos();
        List<ItemStack> stacks = CorporeaHelper.instance().requestItem(request, count, spark, entity, true).stacks();
        spark.onItemsRequested(stacks);
        for (ItemStack reqStack : stacks) {
            if (invPos != null && XplatAbstractions.INSTANCE.insertToInventory(this.level, invPos, Direction.UP, reqStack, true).isEmpty()) {
                InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.level, invPos, Direction.UP, reqStack, false));
                continue;
            }
            ItemEntity item = new ItemEntity(this.level, spark.entity().getX(), spark.entity().getY(), spark.entity().getZ(), reqStack);
            this.level.addFreshEntity((Entity)item);
        }
    }

    @Nullable
    private BlockPos getInvPos() {
        BlockPos downOne = this.worldPosition.below();
        if (XplatAbstractions.INSTANCE.hasInventory(this.level, downOne, Direction.UP)) {
            return downOne;
        }
        BlockPos downTwo = this.worldPosition.below(2);
        if (XplatAbstractions.INSTANCE.hasInventory(this.level, downTwo, Direction.UP)) {
            return downTwo;
        }
        return null;
    }
}

