/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.decor.TinyPotatoBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;

public class TinyPotatoBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements Nameable {
    private static final ResourceLocation BIRTHDAY_ADVANCEMENT = BotaniaAPI.botaniaRL("challenge/tiny_potato_birthday");
    private static final boolean IS_BIRTHDAY = TinyPotatoBlockEntity.isTinyPotatoBirthday();
    private static final String TAG_NAME = "name";
    private static final int JUMP_EVENT = 0;
    private static final Map<String, String> GENDER = new HashMap<String, String>(Map.ofEntries(Map.entry("girlstater", "daughter"), Map.entry("lesbiabtater", "daughter"), Map.entry("lesbiamtater", "daughter"), Map.entry("lesbiantater", "daughter"), Map.entry("lesbitater", "daughter"), Map.entry("lessbientater", "daughter"), Map.entry("agendertater", "child"), Map.entry("enbytater", "child"), Map.entry("nbtater", "child"), Map.entry("nonbinarytater", "child"), Map.entry("robotater", "child"), Map.entry("wiretater", "child"), Map.entry("eutrotater", "child"), Map.entry("bob", "child"), Map.entry("snences", "child"), Map.entry("genderfluidtater", "child"), Map.entry("taterfluid", "child"), Map.entry("eggtater", "child"), Map.entry("tategg", "child"), Map.entry("transtater", "child"), Map.entry("manytater", "children"), Map.entry("pluraltater", "children"), Map.entry("snorps", "children"), Map.entry("systater", "children"), Map.entry("systemtater", "children"), Map.entry("tomater", "tomato")));
    public int jumpTicks = 0;
    public Component name = Component.literal((String)"");
    private int nextDoIt = 0;
    private int birthdayTick = 0;
    private static final List<Block> ALL_CANDLE_CAKES = List.of(Blocks.WHITE_CANDLE_CAKE, Blocks.ORANGE_CANDLE_CAKE, Blocks.MAGENTA_CANDLE_CAKE, Blocks.LIGHT_BLUE_CANDLE_CAKE, Blocks.YELLOW_CANDLE_CAKE, Blocks.LIME_CANDLE_CAKE, Blocks.PINK_CANDLE_CAKE, Blocks.GRAY_CANDLE_CAKE, Blocks.LIGHT_GRAY_CANDLE_CAKE, Blocks.CYAN_CANDLE_CAKE, Blocks.PURPLE_CANDLE_CAKE, Blocks.BLUE_CANDLE_CAKE, Blocks.BROWN_CANDLE_CAKE, Blocks.GREEN_CANDLE_CAKE, Blocks.RED_CANDLE_CAKE, Blocks.BLACK_CANDLE_CAKE, Blocks.CANDLE_CAKE);

    public TinyPotatoBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.TINY_POTATO, pos, state);
    }

    public void interact(Player player, InteractionHand hand, ItemStack stack, Direction side) {
        if (!this.level.isClientSide) {
            int index = side.get3DDataValue();
            ItemStack stackAt = this.getItemHandler().getItem(index);
            if (!stackAt.isEmpty() && stack.isEmpty()) {
                player.setItemInHand(hand, stackAt);
                this.getItemHandler().setItem(index, ItemStack.EMPTY);
            } else if (!stack.isEmpty()) {
                ItemStack copy = stack.split(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, stackAt);
                } else if (!stackAt.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(stackAt);
                }
                this.getItemHandler().setItem(index, copy);
            }
            this.jump();
            if (this.name.getString().toLowerCase(Locale.ROOT).trim().endsWith("shia labeouf") && this.nextDoIt == 0) {
                this.nextDoIt = 40;
                this.level.playSound(null, this.worldPosition, BotaniaSounds.doit, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack tater = ItemStack.EMPTY;
            boolean manyTater = false;
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack otherStack = this.getItem(i);
                if (otherStack.isEmpty() || !otherStack.is(BotaniaBlocks.tinyPotato.asItem())) continue;
                if (tater.isEmpty()) {
                    tater = otherStack;
                    continue;
                }
                manyTater = true;
                break;
            }
            if (!tater.isEmpty()) {
                String taterGender;
                String string = taterGender = manyTater ? "children" : "son";
                if (!manyTater && tater.has(DataComponents.CUSTOM_NAME)) {
                    StringBuilder childNameBuilder = new StringBuilder();
                    TinyPotatoBlockItem.isEnchantedName(tater.getHoverName(), childNameBuilder);
                    taterGender = GENDER.getOrDefault(childNameBuilder.toString(), taterGender);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)("botania.tater.my_" + taterGender)), true);
                }
            }
            player.awardStat(BotaniaStats.TINY_POTATOES_PETTED);
            PlayerHelper.grantCriterion((ServerPlayer)player, BotaniaAPI.botaniaRL("main/tiny_potato_pet"), "code_triggered");
        }
    }

    private void jump() {
        if (this.jumpTicks == 0) {
            this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 20);
        }
    }

    public boolean triggerEvent(int id, int param) {
        if (id == 0) {
            this.jumpTicks = param;
            return true;
        }
        return super.triggerEvent(id, param);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TinyPotatoBlockEntity self) {
        if (self.jumpTicks > 0) {
            --self.jumpTicks;
        }
        if (!level.isClientSide) {
            if (level.random.nextInt(100) == 0) {
                self.jump();
            }
            if (self.nextDoIt > 0) {
                --self.nextDoIt;
            }
            if (IS_BIRTHDAY) {
                self.tickBirthday();
            }
        }
    }

    private void tickBirthday() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockPos facingPos = this.getBlockPos().relative(facing);
        if (this.level.hasChunkAt(facingPos)) {
            BlockState facingState = this.level.getBlockState(facingPos);
            DyeColor cakeColor = TinyPotatoBlockEntity.getLitCakeColor(facingState, this.level.getRandom());
            List<Player> players = PlayerHelper.getRealPlayersIn(this.level, VecHelper.boxForRange(Vec3.atCenterOf((Vec3i)this.getBlockPos()), 8.0));
            if (cakeColor != null && !players.isEmpty()) {
                ++this.birthdayTick;
                List<Integer> messageTimes = List.of(Integer.valueOf(100), Integer.valueOf(170), Integer.valueOf(240), Integer.valueOf(310), Integer.valueOf(380));
                int messageIndex = messageTimes.indexOf(this.birthdayTick);
                if (messageIndex != -1) {
                    Object[] objectArray;
                    if (messageIndex == 1) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TinyPotatoBlockEntity.getTinyPotatoAge();
                    } else {
                        objectArray = ObjectArrays.EMPTY_ARRAY;
                    }
                    Object[] args = objectArray;
                    MutableComponent message = Component.literal((String)"<").append(this.getDisplayName()).append("> ").append((Component)Component.translatable((String)("botania.tater_birthday." + messageIndex), (Object[])args));
                    for (Player player : players) {
                        player.sendSystemMessage((Component)message);
                    }
                    this.jump();
                    TinyPotatoBlock.spawnHearts((ServerLevel)this.level, this.getBlockPos());
                }
                if (messageIndex == messageTimes.size() - 1) {
                    CompoundTag explosion = new CompoundTag();
                    explosion.putByte("Type", (byte)FireworkExplosion.Shape.LARGE_BALL.getId());
                    explosion.putBoolean("Flicker", true);
                    explosion.putBoolean("Trail", true);
                    explosion.putIntArray("Colors", List.of(Integer.valueOf(cakeColor.getFireworkColor()), Integer.valueOf(13787301), Integer.valueOf(14987213), Integer.valueOf(0xFEFEFE), Integer.valueOf(5754616)));
                    ListTag explosions = new ListTag();
                    explosions.add((Object)explosion);
                    ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
                    CompoundTag rocketFireworks = new CompoundTag();
                    rocketFireworks.putByte("Flight", (byte)0);
                    rocketFireworks.put("Explosions", (Tag)explosions);
                    this.level.addFreshEntity((Entity)new FireworkRocketEntity(this.level, (double)facingPos.getX() + 0.5, (double)facingPos.getY() + 0.5, (double)facingPos.getZ() + 0.5, rocket));
                    this.level.removeBlock(facingPos, false);
                    this.level.levelEvent(2001, facingPos, Block.getId((BlockState)facingState));
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.GENERIC_EAT, SoundSource.BLOCKS, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                    for (Player player : players) {
                        PlayerHelper.grantCriterion((ServerPlayer)player, BIRTHDAY_ADVANCEMENT, "code_triggered");
                    }
                }
            }
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.writePacketNBT(cmp, registries);
        cmp.putString(TAG_NAME, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        super.readPacketNBT(cmp, registries);
        this.name = Component.Serializer.fromJson((String)cmp.getString(TAG_NAME), (HolderLookup.Provider)registries);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(this, 6){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    @NotNull
    public Component getName() {
        return BotaniaBlocks.tinyPotato.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name.getString().isEmpty() ? null : this.name;
    }

    @NotNull
    public Component getDisplayName() {
        return this.hasCustomName() ? this.getCustomName() : this.getName();
    }

    @Nullable
    private static DyeColor getLitCakeColor(BlockState state, RandomSource rand) {
        int idx = ALL_CANDLE_CAKES.indexOf(state.getBlock());
        if (idx == -1) {
            return null;
        }
        if (!((Boolean)state.getValue((Property)CandleCakeBlock.LIT)).booleanValue()) {
            return null;
        }
        if (idx == 16) {
            return DyeColor.byId((int)rand.nextInt(16));
        }
        return DyeColor.byId((int)idx);
    }

    private static boolean isTinyPotatoBirthday() {
        LocalDateTime now = LocalDateTime.now();
        return now.getMonth() == Month.JULY && now.getDayOfMonth() == 19;
    }

    private static int getTinyPotatoAge() {
        LocalDateTime now = LocalDateTime.now();
        return now.getYear() - 2014;
    }
}

