/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Predicates;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TerrestrialAgglomerationPlateBlockEntity
extends BotaniaBlockEntity
implements SparkAttachable,
ManaReceiver {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), BotaniaBlocks.terraPlate, Character.valueOf('R'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.TERRA_PLATE_BASE), Character.valueOf('0'), PatchouliAPI.get().tagMatcher(BotaniaTags.Blocks.TERRA_PLATE_BASE), Character.valueOf('L'), PatchouliAPI.get().tagMatcher(XplatAbstractions.INSTANCE.isFabric() ? TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"lapis_blocks")) : TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"storage_blocks/lapis")))}));
    private static final String TAG_MANA = "mana";
    private int mana;

    public TerrestrialAgglomerationPlateBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.TERRA_PLATE, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TerrestrialAgglomerationPlateBlockEntity self) {
        boolean removeMana = true;
        if (self.hasValidPlatform()) {
            List<ItemStack> items = self.getItems();
            SimpleContainer inv = self.getInventory();
            TerrestrialAgglomerationRecipe recipe = self.getCurrentRecipe(inv);
            if (recipe != null) {
                removeMana = false;
                ManaSpark spark = self.getAttachedSpark();
                if (spark != null) {
                    List<ManaSpark> otherSparks = SparkHelper.getSparksAround(level, (double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.5, (double)worldPosition.getZ() + 0.5, spark.getNetwork());
                    for (ManaSpark otherSpark : otherSparks) {
                        if (spark == otherSpark || !(otherSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                        otherSpark.registerTransfer(spark);
                    }
                }
                if (self.mana > 0) {
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                    int proportion = Float.floatToIntBits(self.getCompletion());
                    XplatAbstractions.INSTANCE.sendToNear(level, worldPosition, new BotaniaEffectPacket(EffectType.TERRA_PLATE, worldPosition.getX(), worldPosition.getY(), worldPosition.getZ(), proportion));
                }
                if (self.mana >= recipe.getMana()) {
                    ItemStack result = ItemStack.EMPTY;
                    for (ItemStack item : items) {
                        item.setCount(0);
                    }
                    ItemEntity item = new ItemEntity(level, (double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.2, (double)worldPosition.getZ() + 0.5, result);
                    item.setDeltaMovement(Vec3.ZERO);
                    level.addFreshEntity((Entity)item);
                    level.playSound(null, item.getX(), item.getY(), item.getZ(), BotaniaSounds.terrasteelCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
                    self.mana = 0;
                    level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
                }
            }
        }
        if (removeMana) {
            self.receiveMana(-1000);
        }
    }

    private List<ItemStack> getItems() {
        List itemEntities = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition), EntitySelector.ENTITY_STILL_ALIVE);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntities) {
            if (entity.getItem().isEmpty()) continue;
            stacks.add(entity.getItem());
        }
        return stacks;
    }

    private SimpleContainer getInventory() {
        List<ItemStack> items = this.getItems();
        return new SimpleContainer(TerrestrialAgglomerationPlateBlockEntity.flattenStacks(items));
    }

    private static ItemStack[] flattenStacks(List<ItemStack> items) {
        int i = 0;
        for (ItemStack item : items) {
            i += item.getCount();
        }
        if (i > 64) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[i];
        int j = 0;
        for (ItemStack item : items) {
            if (item.getCount() > 1) {
                ItemStack temp = item.copyWithCount(1);
                for (int count = 0; count < item.getCount(); ++count) {
                    stacks[j] = temp.copy();
                    ++j;
                }
                continue;
            }
            stacks[j] = item;
            ++j;
        }
        return stacks;
    }

    @Nullable
    private TerrestrialAgglomerationRecipe getCurrentRecipe(SimpleContainer items) {
        if (items.isEmpty()) {
            return null;
        }
        return null;
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory()) != null;
    }

    private boolean hasValidPlatform() {
        return MULTIBLOCK.get().validate(this.level, this.getBlockPos().below()) != null;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.mana = cmp.getInt(TAG_MANA);
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition.above()), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    @Override
    public int getAvailableSpaceForMana() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        TerrestrialAgglomerationRecipe recipe = this.getCurrentRecipe(this.getInventory());
        if (recipe == null) {
            return 0.0f;
        }
        return (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

