/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.proxy.Proxy;

public class StarfieldCreatorBlockEntity
extends BotaniaBlockEntity {
    public StarfieldCreatorBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.STARFIELD, pos, state);
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, StarfieldCreatorBlockEntity self) {
        level.updateSkyBrightness();
        if (level.isDay()) {
            return;
        }
        double radius = 512.0;
        int iter = 2;
        for (int i = 0; i < iter; ++i) {
            double x = (double)worldPosition.getX() + 0.5 + (Math.random() - 0.5) * radius;
            double y = Math.min(256, worldPosition.getY() + Proxy.INSTANCE.getClientRenderDistance() * 16);
            double z = (double)worldPosition.getZ() + 0.5 + (Math.random() - 0.5) * radius;
            float w = 0.6f;
            float c = 1.0f - w;
            float r = w + (float)Math.random() * c;
            float g = w + (float)Math.random() * c;
            float b = w + (float)Math.random() * c;
            float s = 20.0f + (float)Math.random() * 20.0f;
            int m = 50;
            SparkleParticleData data = SparkleParticleData.sparkle(s, r, g, b, m);
            level.addParticle((ParticleOptions)data, true, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

