/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.xplat.XplatAbstractions;

public class SparkTinkererBlockEntity
extends ExposedSimpleInventoryBlockEntity {
    public SparkTinkererBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.SPARK_CHANGER, pos, state);
    }

    public void doSwap() {
        if (this.level.isClientSide) {
            return;
        }
        ItemStack changeStack = this.getItemHandler().getItem(0);
        ArrayList<SparkAttachable> attachables = new ArrayList<SparkAttachable>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            SparkUpgradeType newUpg;
            SparkUpgradeType upg;
            ManaSpark spark;
            BlockPos pos = this.worldPosition.relative(dir);
            SparkAttachable attach = XplatAbstractions.INSTANCE.findSparkAttachable(this.level, pos, this.level.getBlockState(pos), this.level.getBlockEntity(pos), dir.getOpposite());
            if (attach == null || (spark = attach.getAttachedSpark()) == null || (upg = spark.getUpgrade()) == (newUpg = changeStack.isEmpty() ? SparkUpgradeType.NONE : ((SparkAugmentItem)changeStack.getItem()).type)) continue;
            attachables.add(attach);
        }
        if (attachables.size() > 0) {
            SparkAttachable attach = (SparkAttachable)attachables.get(this.level.random.nextInt(attachables.size()));
            ManaSpark spark = attach.getAttachedSpark();
            SparkUpgradeType upg = spark.getUpgrade();
            ItemStack sparkStack = SparkAugmentItem.getByType(upg);
            SparkUpgradeType newUpg = changeStack.isEmpty() ? SparkUpgradeType.NONE : ((SparkAugmentItem)changeStack.getItem()).type;
            spark.setUpgrade(newUpg);
            this.getItemHandler().setItem(0, sparkStack);
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(this, 1){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean canPlaceItem(int index, ItemStack stack) {
                return !stack.isEmpty() && stack.getItem() instanceof SparkAugmentItem;
            }
        };
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }
}

