/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public abstract class SimpleInventoryBlockEntity
extends BotaniaBlockEntity
implements Clearable {
    private final SimpleContainer itemHandler = this.createItemHandler();

    protected SimpleInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.addListener(i -> this.setChanged());
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.getContainerSize() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.setItem(i, (ItemStack)src.get(i));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ret.set(i, (Object)inv.getItem(i));
        }
        return ret;
    }

    @Override
    public void readPacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        NonNullList tmp = NonNullList.withSize((int)this.inventorySize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)tmp, (HolderLookup.Provider)registries);
        SimpleInventoryBlockEntity.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    @Override
    public void writePacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        ContainerHelper.saveAllItems((CompoundTag)tag, SimpleInventoryBlockEntity.copyFromInv((Container)this.itemHandler), (HolderLookup.Provider)registries);
    }

    public final int inventorySize() {
        return this.getItemHandler().getContainerSize();
    }

    protected abstract SimpleContainer createItemHandler();

    public void clearContent() {
        this.getItemHandler().clearContent();
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }
}

