/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class PlatformBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    private static final String TAG_CAMO = "camo";
    @Nullable
    private BlockState camoState;

    public PlatformBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.PLATFORM, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player != null) {
            PlatformBlock.Variant variant = this.getVariant();
            if (variant.indestructible && !player.isCreative()) {
                return false;
            }
            if (this.getCamoState() == null || player.isShiftKeyDown()) {
                this.swapSelfAndPass(this, true, variant);
            } else {
                this.swapSurroudings(this, false, variant);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getCamoState() {
        return this.camoState;
    }

    public void setCamoState(@Nullable BlockState state) {
        this.camoState = state;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            if (!this.level.isClientSide) {
                this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
                this.setChanged();
            }
        }
    }

    private PlatformBlock.Variant getVariant() {
        return ((PlatformBlock)this.getBlockState().getBlock()).getVariant();
    }

    private void swapSelfAndPass(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        this.swap(tile, empty);
        this.swapSurroudings(tile, empty, variant);
    }

    private void swapSurroudings(PlatformBlockEntity tile, boolean empty, PlatformBlock.Variant variant) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = tile.getBlockPos().relative(dir);
            BlockEntity tileAt = this.level.getBlockEntity(pos);
            if (!(tileAt instanceof PlatformBlockEntity)) continue;
            PlatformBlockEntity platform = (PlatformBlockEntity)tileAt;
            if (tile.getVariant() != platform.getVariant() || empty != (platform.getCamoState() != null)) continue;
            this.swapSelfAndPass(platform, empty, variant);
        }
    }

    private void swap(PlatformBlockEntity tile, boolean empty) {
        tile.setCamoState(empty ? null : this.getCamoState());
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        if (this.getCamoState() != null) {
            cmp.put(TAG_CAMO, (Tag)NbtUtils.writeBlockState((BlockState)this.getCamoState()));
        }
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        Object holderGetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        BlockState state = NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)cmp.getCompound(TAG_CAMO));
        if (state.isAir()) {
            state = null;
        }
        this.setCamoState(state);
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public Object getRenderData() {
        return new PlatformData(this);
    }

    public record PlatformData(BlockPos pos, @Nullable BlockState state) {
        public PlatformData(PlatformBlockEntity tile) {
            this(tile.getBlockPos().immutable(), tile.camoState);
        }
    }
}

