/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlockEntity
extends SimpleInventoryBlockEntity
implements PetalApothecary {
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    private List<ItemStack> lastRecipe = null;
    private Ingredient lastReagent = Ingredient.EMPTY;
    private int recipeKeepTicks = 0;

    public PetalApothecaryBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ALTAR, pos, state);
    }

    public boolean collideEntityItem(ItemEntity item) {
        ItemStack stack = item.getItem();
        if (this.level.isClientSide || stack.isEmpty() || !item.isAlive()) {
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.EMPTY) {
            MobBucketItem bucketItem;
            Item item2 = stack.getItem();
            if (item2 instanceof MobBucketItem && XplatAbstractions.INSTANCE.getBucketFluid((BucketItem)(bucketItem = (MobBucketItem)item2)) == Fluids.WATER) {
                this.setFluid(PetalApothecary.State.WATER);
                bucketItem.checkExtraContent(null, this.level, stack, this.getBlockPos().above());
                item.setItem(new ItemStack((ItemLike)Items.BUCKET));
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned = true;
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.WATER)) {
                this.setFluid(PetalApothecary.State.WATER);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned = true;
                return true;
            }
            if (XplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (Fluid)Fluids.LAVA)) {
                this.setFluid(PetalApothecary.State.LAVA);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned = true;
                return true;
            }
            return false;
        }
        if (this.getFluid() == PetalApothecary.State.LAVA) {
            item.setRemainingFireTicks(2000);
            return true;
        }
        if (!XplatAbstractions.INSTANCE.isFluidContainer(item) && !XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).apothecarySpawned) {
            if (!this.getItemHandler().getItem(this.inventorySize() - 1).isEmpty()) {
                return false;
            }
            if (this.lastReagent.test(item.getItem())) {
                return false;
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                if (!this.getItemHandler().getItem(i).isEmpty()) continue;
                this.getItemHandler().setItem(i, stack.split(1));
                EntityHelper.syncItem(item);
                this.level.playSound(null, this.worldPosition, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.1f, 10.0f);
                this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos());
                this.clearLastRecipe();
                return true;
            }
        }
        return false;
    }

    @Nullable
    private CustomApothecaryColor getFlowerComponent(ItemStack stack) {
        CustomApothecaryColor c = null;
        Item item = stack.getItem();
        if (item instanceof CustomApothecaryColor) {
            CustomApothecaryColor color;
            c = color = (CustomApothecaryColor)item;
        }
        return c;
    }

    public void saveLastRecipe(Ingredient reagent) {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().getItem(i)).isEmpty(); ++i) {
            this.lastRecipe.add(stack.copy());
        }
        this.lastReagent = reagent;
        this.recipeKeepTicks = 400;
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, 400);
    }

    public void clearLastRecipe() {
        this.lastRecipe = null;
        this.lastReagent = Ingredient.EMPTY;
    }

    public ItemInteractionResult trySetLastRecipe(Player player) {
        if (player.level().isClientSide()) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, SoundEvents.GENERIC_SPLASH);
        if (success) {
            this.level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? ItemInteractionResult.sidedSuccess((boolean)false) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void tickRecipeKeep() {
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.clearLastRecipe();
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, PetalApothecaryBlockEntity self) {
        List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(worldPosition.above()));
        boolean didChange = false;
        for (ItemEntity item : items) {
            didChange = self.collideEntityItem(item) || didChange;
        }
        if (didChange) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.tickRecipeKeep();
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, PetalApothecaryBlockEntity self) {
        ItemStack stackAt;
        for (int i = 0; i < self.inventorySize() && !(stackAt = self.getItemHandler().getItem(i)).isEmpty(); ++i) {
            if (!(Math.random() >= 0.97)) continue;
            CustomApothecaryColor comp = self.getFlowerComponent(stackAt);
            int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() >= 0.75) {
                level.playSound(null, worldPosition, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.1f, 10.0f);
            }
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
            level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)worldPosition.getY() + 1.2, (double)worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
        }
        if (self.getFluid() == PetalApothecary.State.LAVA) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.getY() + 1), (double)worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
            if (Math.random() > 0.9) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.getY() + 1), (double)worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
            }
        }
        self.tickRecipeKeep();
    }

    public boolean triggerEvent(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.level.isClientSide) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.level.addParticle((ParticleOptions)data, (double)this.worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), BotaniaSounds.altarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.triggerEvent(id, param);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(this, 16){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(PetalApothecary.State fluid) {
        this.setFluid(fluid, true);
    }

    public void setFluid(PetalApothecary.State fluid, boolean withVibration) {
        if (withVibration) {
            this.level.gameEvent(null, (Holder)(fluid == PetalApothecary.State.EMPTY ? GameEvent.FLUID_PICKUP : GameEvent.FLUID_PLACE), this.getBlockPos());
        }
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(PetalApothecaryBlock.FLUID, (Comparable)((Object)fluid)));
    }

    @Override
    public PetalApothecary.State getFluid() {
        return (PetalApothecary.State)((Object)this.getBlockState().getValue(PetalApothecaryBlock.FLUID));
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty() && this.getFluid() == PetalApothecary.State.WATER;
    }

    public static class Hud {
        public static void render(PetalApothecaryBlockEntity altar, GuiGraphics gui, Minecraft mc) {
            int xc = mc.getWindow().getGuiScaledWidth() / 2;
            int yc = mc.getWindow().getGuiScaledHeight() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().getItem(i).isEmpty(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    Matrix4fStack pose = RenderSystem.getModelViewStack();
                    pose.pushMatrix();
                    pose.translate((float)xPos, (float)yPos, 0.0f);
                    RenderSystem.applyModelViewMatrix();
                    gui.renderFakeItem(altar.getItemHandler().getItem(i), 0, 0);
                    pose.popMatrix();
                    RenderSystem.applyModelViewMatrix();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = I18n.get((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.drawString(mc.font, s, xc - mc.font.width(s) / 2, yc + 10, 0xFFFFFF, false);
                s = I18n.get((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.drawString(mc.font, s, xc - mc.font.width(s) / 2, yc + 20, 0xFFFFFF, false);
            }
        }
    }
}

