/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

public class LuminizerBlockEntity
extends BotaniaBlockEntity
implements WandBindable {
    public static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final String TAG_NO_PARTICLE = "noParticle";
    private BlockPos bindPos = Bound.UNBOUND_POS;
    private int ticksElapsed = 0;
    private boolean noParticle = false;

    public LuminizerBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.LIGHT_RELAY, pos, state);
    }

    public void mountEntity(Entity e) {
        BlockPos nextDest = this.getNextDestination();
        if (e.isPassenger() || this.level.isClientSide || nextDest == null || !this.isValidBinding()) {
            return;
        }
        PlayerMoverEntity mover = new PlayerMoverEntity(this.level, this.worldPosition, nextDest);
        this.level.addFreshEntity((Entity)mover);
        e.startRiding((Entity)mover);
        if (!(e instanceof ItemEntity)) {
            mover.playSound(BotaniaSounds.lightRelay, 1.0f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)e;
            PlayerHelper.grantCriterion(serverPlayer, BotaniaAPI.botaniaRL("main/luminizer_ride"), "code_triggered");
        }
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, LuminizerBlockEntity self) {
        Vec3 vec;
        ++self.ticksElapsed;
        BlockPos nextDest = self.getNextDestination();
        if (!self.isNoParticle() && nextDest != null && nextDest.getY() != Integer.MIN_VALUE && self.isValidBinding() && (vec = self.getMovementVector()) != null) {
            double dist = 0.1;
            int size = (int)(vec.length() / dist);
            int count = 10;
            int start = self.ticksElapsed % size;
            Vec3 vecMag = vec.normalize().scale(dist);
            Vec3 vecTip = vecMag.scale((double)start).add((double)worldPosition.getX() + 0.5, (double)worldPosition.getY() + 0.5, (double)worldPosition.getZ() + 0.5);
            double radPer = 0.19634954084936207;
            float mul = 0.5f;
            float mulPer = 0.4f;
            float maxMul = 2.0f;
            WispParticleData data = WispParticleData.wisp(0.1f, 0.4f, 0.4f, 1.0f, 1.0f);
            for (int i = start; i < start + count; ++i) {
                mul = Math.min(maxMul, mul + mulPer);
                double rad = radPer * ((double)i + (double)self.ticksElapsed * 0.4);
                Vec3 intermediate = vecMag.cross(VecHelper.ONE).scale((double)mul);
                Vec3 vecRot = VecHelper.rotate(intermediate, rad, vecMag).add(vecTip);
                level.addParticle((ParticleOptions)data, vecRot.x, vecRot.y, vecRot.z, (double)((float)(-vecMag.x)), (double)((float)(-vecMag.y)), (double)((float)(-vecMag.z)));
                vecTip = vecTip.add(vecMag);
            }
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, LuminizerBlockEntity self) {
        BlockPos endpoint;
        ++self.ticksElapsed;
        BlockPos nextDest = self.getNextDestination();
        if (nextDest != null && nextDest.getY() != Integer.MIN_VALUE && self.isValidBinding() && (endpoint = self.getEndpoint()) != null) {
            AABB aabb = state.getShape((BlockGetter)level, worldPosition).bounds().move(worldPosition);
            float range = 0.6f;
            List enderPearls = level.getEntitiesOfClass(ThrownEnderpearl.class, aabb.inflate((double)range));
            for (ThrownEnderpearl pearl : enderPearls) {
                pearl.teleportTo((double)endpoint.getX() + pearl.getX() - (double)worldPosition.getX(), (double)endpoint.getY() + pearl.getY() - (double)worldPosition.getY(), (double)endpoint.getZ() + pearl.getZ() - (double)worldPosition.getZ());
            }
        }
    }

    private boolean isValidBinding() {
        BlockPos nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        Block block = this.level.getBlockState(nextDest).getBlock();
        return block instanceof LuminizerBlock;
    }

    private BlockPos getEndpoint() {
        ArrayList<LuminizerBlockEntity> pointsPassed = new ArrayList<LuminizerBlockEntity>();
        LuminizerBlockEntity relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            LuminizerBlockEntity tileRelay;
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            BlockEntity tile = this.level.getBlockEntity(coords);
            if (tile == null || !(tile instanceof LuminizerBlockEntity)) {
                return lastCoords;
            }
            relay = tileRelay = (LuminizerBlockEntity)tile;
            lastCoords = coords;
        }
        return null;
    }

    public void setNoParticle() {
        this.noParticle = true;
    }

    public boolean isNoParticle() {
        return this.noParticle;
    }

    public Vec3 getMovementVector() {
        BlockPos dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new Vec3((double)(dest.getX() - this.worldPosition.getX()), (double)(dest.getY() - this.worldPosition.getY()), (double)(dest.getZ() - this.worldPosition.getZ()));
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos;
    }

    public BlockPos getNextDestination() {
        BlockState state = this.getBlockState();
        if (state.is(BotaniaBlocks.lightRelayToggle) && ((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            return null;
        }
        if (state.is(BotaniaBlocks.lightRelayFork)) {
            BlockPos torchPos = null;
            for (int i = -2; i < 3; ++i) {
                BlockPos testPos = this.worldPosition.offset(0, i, 0);
                BlockState testState = this.level.getBlockState(testPos);
                if (!testState.is(BotaniaBlocks.animatedTorch)) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                AnimatedTorchBlockEntity torch = (AnimatedTorchBlockEntity)this.level.getBlockEntity(torchPos);
                Direction side = AnimatedTorchBlockEntity.SIDES[torch.side].getOpposite();
                for (int i = 1; i < 20; ++i) {
                    BlockPos testPos = this.worldPosition.relative(side, i);
                    BlockState testState = this.level.getBlockState(testPos);
                    if (!(testState.getBlock() instanceof LuminizerBlock)) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(Player player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        if (!(player.level().getBlockState(pos).getBlock() instanceof LuminizerBlock) || pos.distSqr((Vec3i)this.getBlockPos()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        this.setChanged();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.bindPos = new BlockPos(cmp.getInt(TAG_BIND_X), cmp.getInt(TAG_BIND_Y), cmp.getInt(TAG_BIND_Z));
        this.noParticle = cmp.getBoolean(TAG_NO_PARTICLE);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_BIND_X, this.bindPos.getX());
        cmp.putInt(TAG_BIND_Y, this.bindPos.getY());
        cmp.putInt(TAG_BIND_Z, this.bindPos.getZ());
        cmp.putBoolean(TAG_NO_PARTICLE, this.noParticle);
    }

    public static class PlayerMoverEntity
    extends Entity {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final EntityDataAccessor<BlockPos> EXIT_POS = SynchedEntityData.defineId(PlayerMoverEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

        public PlayerMoverEntity(EntityType<PlayerMoverEntity> type, Level world) {
            super(type, world);
            this.noPhysics = true;
        }

        public PlayerMoverEntity(Level world, BlockPos pos, BlockPos exitPos) {
            this(BotaniaEntities.PLAYER_MOVER, world);
            this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            this.setExit(exitPos);
        }

        protected void defineSynchedData(SynchedEntityData.Builder builder) {
            builder.define(EXIT_POS, (Object)ManaBurst.NO_SOURCE);
        }

        public void tick() {
            super.tick();
            if (this.getPassengers().isEmpty() && !this.level().isClientSide) {
                this.discard();
                return;
            }
            boolean isItem = this.getPassengers().stream().allMatch(ItemEntity.class::isInstance);
            if (!isItem && this.tickCount % 30 == 0) {
                this.playSound(BotaniaSounds.lightRelay, 0.25f, (float)Math.random() * 0.3f + 0.7f);
            }
            if (!isItem && this.tickCount % 10 == 0) {
                this.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            BlockPos pos = this.blockPosition();
            BlockPos exitPos = this.getExitPos();
            if (!this.level().isClientSide && pos.equals((Object)exitPos)) {
                boolean done = true;
                BlockEntity tile = this.level().getBlockEntity(pos);
                if (tile instanceof LuminizerBlockEntity) {
                    BlockPos bind;
                    LuminizerBlockEntity relay = (LuminizerBlockEntity)tile;
                    BlockState state = this.level().getBlockState(pos);
                    if (state.is(BotaniaBlocks.lightRelayDetector)) {
                        this.level().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
                        this.level().scheduleTick(pos, state.getBlock(), 2);
                    }
                    if ((bind = relay.getNextDestination()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        done = false;
                    }
                }
                if (done) {
                    for (Entity e : this.getPassengers()) {
                        e.stopRiding();
                    }
                    this.discard();
                    return;
                }
            }
            Vec3 thisVec = this.position();
            Vec3 motVec = thisVec.reverse().add((double)exitPos.getX() + 0.5, (double)exitPos.getY() + 0.5, (double)exitPos.getZ() + 0.5).normalize().scale(0.5);
            int count = 4;
            for (int i = 0; i < count; ++i) {
                int color = Mth.hsvToRgb((float)((float)this.tickCount / 36.0f + 1.0f / (float)count * (float)i), (float)1.0f, (float)1.0f);
                double rad = Math.PI * 2 / (double)count * (double)i + (double)this.tickCount / Math.PI;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                double s = 0.4;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                SparkleParticleData data = SparkleParticleData.sparkle(1.2f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 10);
                this.level().addParticle((ParticleOptions)data, this.getX() + cos * s, this.getY() - 0.5, this.getZ() + sin * s, 0.0, 0.0, 0.0);
            }
            this.setPos(this.getX() + motVec.x, this.getY() + motVec.y, this.getZ() + motVec.z);
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean hurt(@NotNull DamageSource source, float damage) {
            return false;
        }

        protected void readAdditionalSaveData(@NotNull CompoundTag cmp) {
            this.setExit(new BlockPos(cmp.getInt(TAG_EXIT_X), cmp.getInt(TAG_EXIT_Y), cmp.getInt(TAG_EXIT_Z)));
        }

        protected void addAdditionalSaveData(@NotNull CompoundTag cmp) {
            BlockPos exit = this.getExitPos();
            cmp.putInt(TAG_EXIT_X, exit.getX());
            cmp.putInt(TAG_EXIT_Y, exit.getY());
            cmp.putInt(TAG_EXIT_Z, exit.getZ());
        }

        public Vec3 getDismountLocationForPassenger(LivingEntity living) {
            Direction direction = living.getDirection();
            int[][] aint = DismountHelper.offsetsForDirection((Direction)direction);
            BlockPos blockpos = this.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (Pose pose : living.getDismountPoses()) {
                AABB axisalignedbb = living.getLocalBoundsForPose(pose);
                for (int[] aint1 : aint) {
                    blockpos$mutable.set(blockpos.getX() + aint1[0], blockpos.getY(), blockpos.getZ() + aint1[1]);
                    double d0 = this.level().getBlockFloorHeight((BlockPos)blockpos$mutable);
                    if (!DismountHelper.isBlockFloorValid((double)d0)) continue;
                    Vec3 vector3d = Vec3.upFromBottomCenterOf((Vec3i)blockpos$mutable, (double)d0);
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)living, (AABB)axisalignedbb.move(vector3d))) continue;
                    living.setPose(pose);
                    return vector3d;
                }
            }
            return super.getDismountLocationForPassenger(living);
        }

        public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
            return new ClientboundAddEntityPacket((Entity)this, entity);
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.entityData.get(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.entityData.set(EXIT_POS, (Object)pos);
        }
    }
}

