/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Suppliers;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;

public abstract class ExposedSimpleInventoryBlockEntity
extends SimpleInventoryBlockEntity
implements WorldlyContainer {
    private final Supplier<int[]> slots = Suppliers.memoize(() -> IntStream.range(0, this.getContainerSize()).toArray());

    protected ExposedSimpleInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isEmpty() {
        return this.getItemHandler().isEmpty();
    }

    public int getContainerSize() {
        return this.inventorySize();
    }

    public ItemStack getItem(int index) {
        return this.getItemHandler().getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.getItemHandler().removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.getItemHandler().removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.getItemHandler().setItem(index, stack);
    }

    public boolean stillValid(Player player) {
        return this.getItemHandler().stillValid(player);
    }

    public int getMaxStackSize() {
        return this.getItemHandler().getMaxStackSize();
    }

    public void startOpen(Player player) {
        this.getItemHandler().startOpen(player);
    }

    public void stopOpen(Player player) {
        this.getItemHandler().stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.getItemHandler().canPlaceItem(index, stack);
    }

    public int countItem(Item item) {
        return this.getItemHandler().countItem(item);
    }

    public boolean hasAnyOf(Set<Item> set) {
        return this.getItemHandler().hasAnyOf(set);
    }

    public int[] getSlotsForFace(Direction side) {
        return this.slots.get();
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        if (this.canPlaceItem(index, stack)) {
            ItemStack existing = this.getItem(index);
            return existing.getCount() < this.getMaxStackSize();
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return true;
    }
}

