/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.lib.BotaniaTags;

public class CocoonBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    private static final float SPECIAL_CHANCE = 0.075f;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;
    public boolean gaiaSpiritGiven;

    public CocoonBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.COCOON, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, CocoonBlockEntity self) {
        ++self.timePassed;
        if (self.timePassed >= 2400) {
            self.hatch();
        }
    }

    private void hatch() {
        if (!this.level.isClientSide) {
            this.timePassed = 0;
            this.level.destroyBlock(this.worldPosition, false);
            Mob entity = null;
            BlockPos placePos = this.worldPosition;
            float rareChance = this.gaiaSpiritGiven ? 1.0f : 0.075f;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            ArrayList<BlockPos> validWater = new ArrayList<BlockPos>();
            for (Direction d : Direction.values()) {
                BlockPos blockPos;
                BlockPos blockPos2 = blockPos = d == Direction.UP ? this.worldPosition : this.worldPosition.relative(d);
                if (!this.level.hasChunkAt(blockPos) || !this.level.getBlockState(blockPos).is(Blocks.WATER)) continue;
                validWater.add(blockPos);
            }
            if (Math.random() < (double)shulkerChance) {
                entity = (Mob)EntityType.SHULKER.create(this.level);
            } else if (Math.random() < (double)villagerChance) {
                Villager villager = (Villager)EntityType.VILLAGER.create(this.level);
                if (villager != null) {
                    VillagerType type = VillagerType.byBiome((Holder)this.level.getBiome(this.worldPosition));
                    villager.setVillagerData(villager.getVillagerData().setType(type));
                }
                entity = villager;
            } else if (!validWater.isEmpty()) {
                placePos = (BlockPos)validWater.get(this.level.random.nextInt(validWater.size()));
                entity = Math.random() < (double)rareChance ? this.random(BotaniaTags.Entities.COCOON_RARE_AQUATIC) : this.random(BotaniaTags.Entities.COCOON_COMMON_AQUATIC);
            } else {
                entity = Math.random() < (double)rareChance ? this.random(BotaniaTags.Entities.COCOON_RARE) : this.random(BotaniaTags.Entities.COCOON_COMMON);
            }
            if (entity != null) {
                if ((double)this.level.random.nextFloat() < 0.01) {
                    MutableComponent name = Component.literal((String)"Jeanne d'");
                    name.append(entity.getName());
                    name.append((Component)Component.literal((String)" [SSR]"));
                    entity.setCustomName((Component)name.withStyle(ChatFormatting.GOLD));
                    entity.setCustomNameVisible(true);
                }
                entity.setPos((double)placePos.getX() + 0.5, (double)placePos.getY() + 0.5, (double)placePos.getZ() + 0.5);
                if (entity instanceof AgeableMob) {
                    AgeableMob ageable = (AgeableMob)entity;
                    ageable.setAge(-24000);
                }
                entity.finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(this.getBlockPos()), MobSpawnType.EVENT, null);
                entity.setPersistenceRequired();
                this.level.addFreshEntity((Entity)entity);
                entity.spawnAnim();
            }
        }
    }

    public void forceRare() {
        this.gaiaSpiritGiven = true;
        this.timePassed = Math.max(this.timePassed, 1200);
    }

    @Nullable
    private Mob random(TagKey<EntityType<?>> tag) {
        Mob mob;
        Entity entity;
        EntityType type = BuiltInRegistries.ENTITY_TYPE.getTag(tag).flatMap(t -> t.getRandomElement(this.level.random)).map(Holder::value).orElse(null);
        if (type == null) {
            return null;
        }
        if (type == EntityType.COW && (double)this.level.random.nextFloat() < 0.01) {
            type = EntityType.MOOSHROOM;
        }
        return (entity = type.create(this.level)) instanceof Mob ? (mob = (Mob)entity) : null;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_TIME_PASSED, this.timePassed);
        cmp.putInt(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.putInt(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
        cmp.putBoolean(TAG_GAIA_SPIRIT_GIVEN, this.gaiaSpiritGiven);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.timePassed = cmp.getInt(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.getInt(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.getInt(TAG_CHORUS_FRUIT_GIVEN);
        this.gaiaSpiritGiven = cmp.getBoolean(TAG_GAIA_SPIRIT_GIVEN);
    }
}

