/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.Bound;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity;

public class CellularBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_GENERATION = "generation";
    private static final String TAG_TICKED = "ticked";
    private static final String TAG_FLOWER_X = "flowerX";
    private static final String TAG_FLOWER_Y = "flowerY";
    private static final String TAG_FLOWER_Z = "flowerZ";
    private static final String TAG_VALID_X = "validX";
    private static final String TAG_VALID_Y = "validY";
    private static final String TAG_VALID_Z = "validZ";
    private int generation;
    private int nextGeneration;
    private boolean ticked;
    private BlockPos flowerCoords = Bound.UNBOUND_POS;
    private BlockPos validCoords = Bound.UNBOUND_POS;

    public CellularBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CELL_BLOCK, pos, state);
    }

    public void setGeneration(int gen) {
        this.generation = gen;
    }

    public void setNextGeneration(DandelifeonBlockEntity flower, int gen) {
        this.nextGeneration = gen;
        this.getLevel().scheduleTick(this.getBlockPos(), BotaniaBlocks.cellBlock, 1);
        if (!this.ticked) {
            this.claim(flower);
            this.ticked = true;
        } else if (!this.validCoords.equals((Object)this.getBlockPos()) || !this.flowerCoords.equals((Object)flower.getEffectivePos())) {
            this.level.removeBlock(this.worldPosition, false);
        }
    }

    public void claim(DandelifeonBlockEntity flower) {
        if (!this.ticked) {
            this.flowerCoords = flower.getEffectivePos();
            this.validCoords = this.getBlockPos();
        }
    }

    public void update(Level level) {
        if (this.nextGeneration == -1) {
            level.removeBlock(this.getBlockPos(), false);
        }
        this.generation = this.nextGeneration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasActiveParent(DandelifeonBlockEntity dandie) {
        if (this.flowerCoords == null) return false;
        BlockEntity blockEntity = dandie.getLevel().getBlockEntity(this.flowerCoords);
        if (!(blockEntity instanceof DandelifeonBlockEntity)) return false;
        DandelifeonBlockEntity parent = (DandelifeonBlockEntity)blockEntity;
        if (!dandie.getLevel().hasNeighborSignal(this.flowerCoords)) return false;
        if (!dandie.overgrowthBoost) return true;
        if (!parent.isOnSpecialSoil()) return false;
        return true;
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_GENERATION, this.generation);
        cmp.putBoolean(TAG_TICKED, this.ticked);
        if (this.ticked) {
            cmp.putInt(TAG_FLOWER_X, this.flowerCoords.getX());
            cmp.putInt(TAG_FLOWER_Y, this.flowerCoords.getY());
            cmp.putInt(TAG_FLOWER_Z, this.flowerCoords.getZ());
            cmp.putInt(TAG_VALID_X, this.validCoords.getX());
            cmp.putInt(TAG_VALID_Y, this.validCoords.getY());
            cmp.putInt(TAG_VALID_Z, this.validCoords.getZ());
        }
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.generation = cmp.getInt(TAG_GENERATION);
        this.ticked = cmp.getBoolean(TAG_TICKED);
        if (this.ticked) {
            this.flowerCoords = new BlockPos(cmp.getInt(TAG_FLOWER_X), cmp.getInt(TAG_FLOWER_Y), cmp.getInt(TAG_FLOWER_Z));
            this.validCoords = new BlockPos(cmp.getInt(TAG_VALID_X), cmp.getInt(TAG_VALID_Y), cmp.getInt(TAG_VALID_Z));
        }
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }
}

