/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.AvatarBlockEntity;
import vazkii.botania.common.block.block_entity.BifrostBlockEntity;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;
import vazkii.botania.common.block.block_entity.CellularBlockEntity;
import vazkii.botania.common.block.block_entity.CocoonBlockEntity;
import vazkii.botania.common.block.block_entity.CraftyCrateBlockEntity;
import vazkii.botania.common.block.block_entity.EnderOverseerBlockEntity;
import vazkii.botania.common.block.block_entity.EyeOfTheAncientsBlockEntity;
import vazkii.botania.common.block.block_entity.FakeAirBlockEntity;
import vazkii.botania.common.block.block_entity.FloatingFlowerBlockEntity;
import vazkii.botania.common.block.block_entity.GaiaHeadBlockEntity;
import vazkii.botania.common.block.block_entity.HoveringHourglassBlockEntity;
import vazkii.botania.common.block.block_entity.IncensePlateBlockEntity;
import vazkii.botania.common.block.block_entity.LifeImbuerBlockEntity;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.block.block_entity.OpenCrateBlockEntity;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.SparkTinkererBlockEntity;
import vazkii.botania.common.block.block_entity.StarfieldCreatorBlockEntity;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.block.block_entity.TeruTeruBozuBlockEntity;
import vazkii.botania.common.block.block_entity.TinyPlanetBlockEntity;
import vazkii.botania.common.block.block_entity.TinyPotatoBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaFunnelBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaInterceptorBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaRetainerBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPrismBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaSplitterBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.block_entity.mana.PowerGeneratorBlockEntity;
import vazkii.botania.common.block.block_entity.mana.SpreaderTurntableBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringComparatorBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringDispenserBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringInterceptorBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringNutrifierBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringSpooferBlockEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class BotaniaBlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> ALL = new HashMap();
    public static final BlockEntityType<PetalApothecaryBlockEntity> ALTAR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("altar"), PetalApothecaryBlockEntity::new, BotaniaBlocks.defaultAltar, BotaniaBlocks.forestAltar, BotaniaBlocks.plainsAltar, BotaniaBlocks.mountainAltar, BotaniaBlocks.fungalAltar, BotaniaBlocks.swampAltar, BotaniaBlocks.desertAltar, BotaniaBlocks.taigaAltar, BotaniaBlocks.mesaAltar, BotaniaBlocks.mossyAltar, BotaniaBlocks.livingrockAltar, BotaniaBlocks.deepslateAltar);
    public static final BlockEntityType<ManaSpreaderBlockEntity> SPREADER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_spreader"), ManaSpreaderBlockEntity::new, BotaniaBlocks.manaSpreader, BotaniaBlocks.redstoneSpreader, BotaniaBlocks.elvenSpreader, BotaniaBlocks.gaiaSpreader);
    public static final BlockEntityType<ManaPoolBlockEntity> POOL = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_pool"), ManaPoolBlockEntity::new, BotaniaBlocks.manaPool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.creativePool);
    public static final BlockEntityType<RunicAltarBlockEntity> RUNE_ALTAR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("runic_altar"), RunicAltarBlockEntity::new, BotaniaBlocks.runeAltar);
    public static final BlockEntityType<PylonBlockEntity> PYLON = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_pylon"), PylonBlockEntity::new, BotaniaBlocks.manaPylon, BotaniaBlocks.naturaPylon, BotaniaBlocks.gaiaPylon);
    public static final BlockEntityType<ManaSplitterBlockEntity> DISTRIBUTOR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_distributor"), ManaSplitterBlockEntity::new, BotaniaBlocks.distributor);
    public static final BlockEntityType<ManaEnchanterBlockEntity> ENCHANTER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("enchanter"), ManaEnchanterBlockEntity::new, BotaniaBlocks.enchanter);
    public static final BlockEntityType<SpreaderTurntableBlockEntity> TURNTABLE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("turntable"), SpreaderTurntableBlockEntity::new, BotaniaBlocks.turntable);
    public static final BlockEntityType<TinyPlanetBlockEntity> TINY_PLANET = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("tiny_planet_block"), TinyPlanetBlockEntity::new, BotaniaBlocks.tinyPlanet);
    public static final BlockEntityType<OpenCrateBlockEntity> OPEN_CRATE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("open_crate"), OpenCrateBlockEntity::new, BotaniaBlocks.openCrate);
    public static final BlockEntityType<CraftyCrateBlockEntity> CRAFT_CRATE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("crafty_crate"), CraftyCrateBlockEntity::new, BotaniaBlocks.craftCrate);
    public static final BlockEntityType<EyeOfTheAncientsBlockEntity> FOREST_EYE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("forest_eye"), EyeOfTheAncientsBlockEntity::new, BotaniaBlocks.forestEye);
    public static final BlockEntityType<PlatformBlockEntity> PLATFORM = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("platform"), PlatformBlockEntity::new, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.infrangiblePlatform);
    public static final BlockEntityType<AlfheimPortalBlockEntity> ALF_PORTAL = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("alfheim_portal"), AlfheimPortalBlockEntity::new, BotaniaBlocks.alfPortal);
    public static final BlockEntityType<BifrostBlockEntity> BIFROST = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("bifrost"), BifrostBlockEntity::new, BotaniaBlocks.bifrost);
    public static final BlockEntityType<FloatingFlowerBlockEntity> MINI_ISLAND = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mini_island"), FloatingFlowerBlockEntity::new, (Block[])ColorHelper.supportedColors().map(BotaniaBlocks::getFloatingFlower).toArray(Block[]::new));
    public static final BlockEntityType<TinyPotatoBlockEntity> TINY_POTATO = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("tiny_potato"), TinyPotatoBlockEntity::new, BotaniaBlocks.tinyPotato);
    public static final BlockEntityType<LifeImbuerBlockEntity> SPAWNER_CLAW = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("spawner_claw"), LifeImbuerBlockEntity::new, BotaniaBlocks.spawnerClaw);
    public static final BlockEntityType<EnderOverseerBlockEntity> ENDER_EYE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("ender_eye_block"), EnderOverseerBlockEntity::new, BotaniaBlocks.enderEye);
    public static final BlockEntityType<StarfieldCreatorBlockEntity> STARFIELD = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("starfield"), StarfieldCreatorBlockEntity::new, BotaniaBlocks.starfield);
    public static final BlockEntityType<PowerGeneratorBlockEntity> FLUXFIELD = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_fluxfield"), PowerGeneratorBlockEntity::new, BotaniaBlocks.rfGenerator);
    public static final BlockEntityType<BreweryBlockEntity> BREWERY = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("brewery"), BreweryBlockEntity::new, BotaniaBlocks.brewery);
    public static final BlockEntityType<TerrestrialAgglomerationPlateBlockEntity> TERRA_PLATE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("terra_plate"), TerrestrialAgglomerationPlateBlockEntity::new, BotaniaBlocks.terraPlate);
    public static final BlockEntityType<RedStringContainerBlockEntity> RED_STRING_CONTAINER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_container"), XplatAbstractions.INSTANCE::newRedStringContainer, BotaniaBlocks.redStringContainer);
    public static final BlockEntityType<RedStringDispenserBlockEntity> RED_STRING_DISPENSER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_dispenser"), RedStringDispenserBlockEntity::new, BotaniaBlocks.redStringDispenser);
    public static final BlockEntityType<RedStringNutrifierBlockEntity> RED_STRING_FERTILIZER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_fertilizer"), RedStringNutrifierBlockEntity::new, BotaniaBlocks.redStringFertilizer);
    public static final BlockEntityType<RedStringComparatorBlockEntity> RED_STRING_COMPARATOR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_comparator"), RedStringComparatorBlockEntity::new, BotaniaBlocks.redStringComparator);
    public static final BlockEntityType<RedStringSpooferBlockEntity> RED_STRING_RELAY = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_relay"), RedStringSpooferBlockEntity::new, BotaniaBlocks.redStringRelay);
    public static final BlockEntityType<ManaFlameBlockEntity> MANA_FLAME = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("mana_flame"), ManaFlameBlockEntity::new, BotaniaBlocks.manaFlame);
    public static final BlockEntityType<ManaPrismBlockEntity> PRISM = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("prism"), ManaPrismBlockEntity::new, BotaniaBlocks.prism);
    public static final BlockEntityType<CorporeaIndexBlockEntity> CORPOREA_INDEX = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("corporea_index"), CorporeaIndexBlockEntity::new, BotaniaBlocks.corporeaIndex);
    public static final BlockEntityType<CorporeaFunnelBlockEntity> CORPOREA_FUNNEL = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("corporea_funnel"), CorporeaFunnelBlockEntity::new, BotaniaBlocks.corporeaFunnel);
    public static final BlockEntityType<ManaPumpBlockEntity> PUMP = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("pump"), ManaPumpBlockEntity::new, BotaniaBlocks.pump);
    public static final BlockEntityType<FakeAirBlockEntity> FAKE_AIR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("fake_air"), FakeAirBlockEntity::new, BotaniaBlocks.fakeAir);
    public static final BlockEntityType<CorporeaInterceptorBlockEntity> CORPOREA_INTERCEPTOR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("corporea_interceptor"), CorporeaInterceptorBlockEntity::new, BotaniaBlocks.corporeaInterceptor);
    public static final BlockEntityType<CorporeaCrystalCubeBlockEntity> CORPOREA_CRYSTAL_CUBE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("corporea_crystal_cube"), CorporeaCrystalCubeBlockEntity::new, BotaniaBlocks.corporeaCrystalCube);
    public static final BlockEntityType<IncensePlateBlockEntity> INCENSE_PLATE = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("incense_plate"), IncensePlateBlockEntity::new, BotaniaBlocks.incensePlate);
    public static final BlockEntityType<HoveringHourglassBlockEntity> HOURGLASS = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("hourglass"), HoveringHourglassBlockEntity::new, BotaniaBlocks.hourglass);
    public static final BlockEntityType<SparkTinkererBlockEntity> SPARK_CHANGER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("spark_changer"), SparkTinkererBlockEntity::new, BotaniaBlocks.sparkChanger);
    public static final BlockEntityType<CocoonBlockEntity> COCOON = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("cocoon"), CocoonBlockEntity::new, BotaniaBlocks.cocoon);
    public static final BlockEntityType<LuminizerBlockEntity> LIGHT_RELAY = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("light_relay"), LuminizerBlockEntity::new, BotaniaBlocks.lightRelayDefault, BotaniaBlocks.lightRelayDetector, BotaniaBlocks.lightRelayToggle, BotaniaBlocks.lightRelayFork);
    public static final BlockEntityType<CacophoniumBlockEntity> CACOPHONIUM = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("cacophonium_block"), CacophoniumBlockEntity::new, BotaniaBlocks.cacophonium);
    public static final BlockEntityType<BellowsBlockEntity> BELLOWS = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("bellows"), BellowsBlockEntity::new, BotaniaBlocks.bellows);
    public static final BlockEntityType<CellularBlockEntity> CELL_BLOCK = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("cell_block"), CellularBlockEntity::new, BotaniaBlocks.cellBlock);
    public static final BlockEntityType<RedStringInterceptorBlockEntity> RED_STRING_INTERCEPTOR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("red_string_interceptor"), RedStringInterceptorBlockEntity::new, BotaniaBlocks.redStringInterceptor);
    public static final BlockEntityType<GaiaHeadBlockEntity> GAIA_HEAD = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("gaia_head"), GaiaHeadBlockEntity::new, BotaniaBlocks.gaiaHead, BotaniaBlocks.gaiaHeadWall);
    public static final BlockEntityType<CorporeaRetainerBlockEntity> CORPOREA_RETAINER = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("corporea_retainer"), CorporeaRetainerBlockEntity::new, BotaniaBlocks.corporeaRetainer);
    public static final BlockEntityType<TeruTeruBozuBlockEntity> TERU_TERU_BOZU = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("teru_teru_bozu"), TeruTeruBozuBlockEntity::new, BotaniaBlocks.teruTeruBozu);
    public static final BlockEntityType<AvatarBlockEntity> AVATAR = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("avatar"), AvatarBlockEntity::new, BotaniaBlocks.avatar);
    public static final BlockEntityType<AnimatedTorchBlockEntity> ANIMATED_TORCH = BotaniaBlockEntities.type(BotaniaAPI.botaniaRL("animated_torch"), AnimatedTorchBlockEntity::new, BotaniaBlocks.animatedTorch);

    private static <T extends BlockEntity> BlockEntityType<T> type(ResourceLocation id, BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        BlockEntityType<T> ret = XplatAbstractions.INSTANCE.createBlockEntityType(func, blocks);
        BlockEntityType<T> old = ALL.put(id, ret);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate id " + String.valueOf(id));
        }
        return ret;
    }

    public static void registerTiles(BiConsumer<BlockEntityType<?>, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, BlockEntityType<?>> e : ALL.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerWandHudCaps(BECapConsumer<WandHUD> consumer) {
        consumer.accept(be -> new AnimatedTorchBlockEntity.WandHud((AnimatedTorchBlockEntity)be), ANIMATED_TORCH);
        consumer.accept(be -> new BreweryBlockEntity.WandHud((BreweryBlockEntity)be), BREWERY);
        consumer.accept(be -> new CorporeaRetainerBlockEntity.WandHud((CorporeaRetainerBlockEntity)be), CORPOREA_RETAINER);
        consumer.accept(be -> new CraftyCrateBlockEntity.WandHud((CraftyCrateBlockEntity)be), CRAFT_CRATE);
        consumer.accept(be -> new ManaEnchanterBlockEntity.WandHud((ManaEnchanterBlockEntity)be), ENCHANTER);
        consumer.accept(be -> new HoveringHourglassBlockEntity.WandHud((HoveringHourglassBlockEntity)be), HOURGLASS);
        consumer.accept(be -> new ManaPoolBlockEntity.WandHud((ManaPoolBlockEntity)be), POOL);
        consumer.accept(be -> new ManaPrismBlockEntity.WandHud((ManaPrismBlockEntity)be), PRISM);
        consumer.accept(be -> new ManaSpreaderBlockEntity.WandHud((ManaSpreaderBlockEntity)be), SPREADER);
        consumer.accept(be -> new SpreaderTurntableBlockEntity.WandHud((SpreaderTurntableBlockEntity)be), TURNTABLE);
    }

    public static interface BECapConsumer<T> {
        public void accept(Function<BlockEntity, T> var1, BlockEntityType<?> ... var2);
    }
}

