/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class AvatarBlockEntity
extends SimpleInventoryBlockEntity
implements Avatar,
ManaReceiver {
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "mana";
    private static final String TAG_COOLDOWNS = "boostCooldowns";
    private boolean enabled;
    private int ticksElapsed;
    private int mana;
    private final Map<UUID, Integer> boostCooldowns = new HashMap<UUID, Integer>();

    public AvatarBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.AVATAR, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, AvatarBlockEntity self) {
        AvatarWieldable wieldable;
        self.enabled = !level.hasNeighborSignal(worldPosition);
        ItemStack stack = self.getItemHandler().getItem(0);
        if (!stack.isEmpty() && (wieldable = XplatAbstractions.INSTANCE.findAvatarWieldable(stack)) != null) {
            wieldable.onAvatarUpdate(self);
        }
        if (self.enabled) {
            ++self.ticksElapsed;
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        super.writePacketNBT(tag, registries);
        tag.putBoolean(TAG_ENABLED, this.enabled);
        tag.putInt(TAG_TICKS_ELAPSED, this.ticksElapsed);
        tag.putInt(TAG_MANA, this.mana);
        ListTag boostCooldowns = new ListTag();
        for (Map.Entry<UUID, Integer> e : this.boostCooldowns.entrySet()) {
            CompoundTag cmp = new CompoundTag();
            cmp.putUUID("id", e.getKey());
            cmp.putInt("cooldown", e.getValue().intValue());
            boostCooldowns.add((Object)cmp);
        }
        tag.put(TAG_COOLDOWNS, (Tag)boostCooldowns);
    }

    @Override
    public void readPacketNBT(CompoundTag tag, HolderLookup.Provider registries) {
        super.readPacketNBT(tag, registries);
        this.enabled = tag.getBoolean(TAG_ENABLED);
        this.ticksElapsed = tag.getInt(TAG_TICKS_ELAPSED);
        this.mana = tag.getInt(TAG_MANA);
        this.boostCooldowns.clear();
        ListTag boostCooldowns = tag.getList(TAG_COOLDOWNS, 10);
        for (Tag nbt : boostCooldowns) {
            CompoundTag cmp = (CompoundTag)nbt;
            UUID id = cmp.getUUID("id");
            int cooldown = cmp.getInt("cooldown");
            this.boostCooldowns.put(id, cooldown);
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(this, 1){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(19200, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.getItemHandler().getItem(0).isEmpty();
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public Container getInventory() {
        return this.getItemHandler();
    }

    @Override
    public Direction getAvatarFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Map<UUID, Integer> getBoostCooldowns() {
        return this.boostCooldowns;
    }
}

