/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class AnimatedTorchBlockEntity
extends BotaniaBlockEntity
implements ManaTrigger,
Wandable {
    private static final String TAG_SIDE = "side";
    private static final String TAG_ROTATING = "rotating";
    private static final String TAG_ROTATION_TICKS = "rotationTicks";
    private static final String TAG_ANGLE_PER_TICK = "anglePerTick";
    private static final String TAG_TORCH_MODE = "torchMode";
    private static final String TAG_NEXT_RANDOM_ROTATION = "nextRandomRotation";
    public static final Direction[] SIDES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public int side;
    public double rotation;
    public boolean rotating;
    public boolean directionInitialized;
    public double lastTickRotation;
    public int nextRandomRotation = Mth.floor((double)(Math.random() * 3.0));
    public int currentRandomRotation;
    private int rotationTicks;
    public double anglePerTick;
    private TorchMode torchMode = TorchMode.TOGGLE;

    public AnimatedTorchBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ANIMATED_TORCH, pos, state);
    }

    public void handRotate() {
        if (!this.level.isClientSide) {
            this.level.blockEvent(this.getBlockPos(), BotaniaBlocks.animatedTorch, 0, (this.side + 1) % 4);
        }
    }

    public void onPlace(@Nullable LivingEntity entity) {
        if (entity != null) {
            this.side = Arrays.asList(SIDES).indexOf(entity.getDirection().getOpposite());
        }
        this.directionInitialized = true;
        AnimatedTorchBlockEntity.updateNeighbors(this.level, this.worldPosition, this.getBlockState(), this.side);
    }

    public void setRemoved() {
        this.directionInitialized = false;
        super.setRemoved();
    }

    public void toggle() {
        if (!this.level.isClientSide) {
            this.level.blockEvent(this.getBlockPos(), BotaniaBlocks.animatedTorch, 0, this.torchMode.modeSwitcher.rotate(this, this.side));
            this.nextRandomRotation = this.level.random.nextInt(4);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean onUsedByWand(Player player, ItemStack stack, Direction side) {
        int modeOrdinal = this.torchMode.ordinal();
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[(modeOrdinal + 1) % modes.length];
        return true;
    }

    public boolean triggerEvent(int id, int param) {
        if (id == 0) {
            this.rotateTo(param);
            return true;
        }
        return super.triggerEvent(id, param);
    }

    private void rotateTo(int side) {
        if (this.rotating) {
            return;
        }
        this.currentRandomRotation = this.nextRandomRotation;
        int finalRotation = side * 90;
        double diff = ((double)finalRotation - this.rotation % 360.0) % 360.0;
        if (diff < 0.0) {
            diff = 360.0 + diff;
        }
        this.rotationTicks = 4;
        this.anglePerTick = diff / (double)this.rotationTicks;
        int oldSide = this.side;
        this.side = side;
        this.rotating = true;
        AnimatedTorchBlockEntity.updateNeighbors(this.level, this.worldPosition, this.getBlockState(), oldSide);
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        if (!burst.isFake()) {
            this.toggle();
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, AnimatedTorchBlockEntity self) {
        if (!self.directionInitialized) {
            self.directionInitialized = true;
        }
        if (self.rotating) {
            self.lastTickRotation = self.rotation;
            self.rotation = (self.rotation + self.anglePerTick) % 360.0;
            --self.rotationTicks;
            if (self.rotationTicks <= 0) {
                self.rotating = false;
                AnimatedTorchBlockEntity.updateNeighbors(level, worldPosition, state, self.side);
            }
        } else {
            self.rotation = self.side * 90;
        }
        if (level.isClientSide) {
            int amt = self.rotating ? 3 : (Math.random() < 0.1 ? 1 : 0);
            double x = (double)worldPosition.getX() + 0.5 + Math.cos((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            double y = (double)worldPosition.getY() + 0.2;
            double z = (double)worldPosition.getZ() + 0.5 + Math.sin((self.rotation + 90.0) / 180.0 * Math.PI) * 0.35;
            for (int i = 0; i < amt; ++i) {
                level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void updateNeighbors(Level level, BlockPos worldPosition, BlockState state, int self) {
        level.updateNeighborsAt(worldPosition, state.getBlock());
        BlockPos targetPos = worldPosition.relative(SIDES[self].getOpposite());
        level.updateNeighborsAtExceptFromFacing(targetPos, level.getBlockState(targetPos).getBlock(), SIDES[self]);
    }

    @Override
    public void writePacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        cmp.putInt(TAG_SIDE, this.side);
        cmp.putBoolean(TAG_ROTATING, this.rotating);
        cmp.putInt(TAG_ROTATION_TICKS, this.rotationTicks);
        cmp.putDouble(TAG_ANGLE_PER_TICK, this.anglePerTick);
        cmp.putInt(TAG_TORCH_MODE, this.torchMode.ordinal());
        cmp.putInt(TAG_NEXT_RANDOM_ROTATION, this.nextRandomRotation);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp, HolderLookup.Provider registries) {
        this.side = cmp.getInt(TAG_SIDE);
        this.rotating = cmp.getBoolean(TAG_ROTATING);
        if (this.level != null && !this.level.isClientSide) {
            this.rotationTicks = cmp.getInt(TAG_ROTATION_TICKS);
        }
        this.anglePerTick = cmp.getDouble(TAG_ANGLE_PER_TICK);
        this.nextRandomRotation = cmp.getInt(TAG_NEXT_RANDOM_ROTATION);
        int modeOrdinal = cmp.getInt(TAG_TORCH_MODE);
        TorchMode[] modes = TorchMode.values();
        this.torchMode = modes[modeOrdinal % modes.length];
    }

    public static enum TorchMode {
        TOGGLE((t, i) -> (i + 2) % 4),
        ROTATE((t, i) -> (i + 1) % 4),
        RANDOM((t, i) -> t.currentRandomRotation);

        public final RotationHandler modeSwitcher;

        private TorchMode(RotationHandler modeSwitcher) {
            this.modeSwitcher = modeSwitcher;
        }

        private static interface RotationHandler {
            public int rotate(AnimatedTorchBlockEntity var1, int var2);
        }
    }

    public static class WandHud
    implements WandHUD {
        private final AnimatedTorchBlockEntity torch;

        public WandHud(AnimatedTorchBlockEntity torch) {
            this.torch = torch;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            int x = mc.getWindow().getGuiScaledWidth() / 2 + 8;
            int y = mc.getWindow().getGuiScaledHeight() / 2 - 10;
            String str = I18n.get((String)("botania.animatedTorch." + this.torch.torchMode.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            RenderHelper.renderHUDBox(gui, x, y, x + 18 + mc.font.width(str), y + 20);
            gui.renderFakeItem(new ItemStack((ItemLike)Blocks.REDSTONE_TORCH), x, y + 2);
            gui.drawString(mc.font, str, x + 16, y + 6, 0xFF4444);
        }
    }
}

