/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.BotaniaBlocks;

public class SpecialFlowerBlock
extends FlowerBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = SpecialFlowerBlock.box((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    private final Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType;
    private final boolean hasComparatorOutput;

    public SpecialFlowerBlock(Holder<MobEffect> stewEffect, int stewDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType) {
        this(stewEffect, stewDuration, props, blockEntityType, false);
    }

    public SpecialFlowerBlock(Holder<MobEffect> stewEffect, int stewDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType, boolean hasComparatorOutput) {
        super(stewEffect, (float)stewDuration, props);
        this.blockEntityType = blockEntityType;
        this.hasComparatorOutput = hasComparatorOutput;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext ctx) {
        Vec3 shift = state.getOffset(world, pos);
        return SHAPE.move(shift.x, shift.y, shift.z);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.is(BotaniaBlocks.redStringRelay) || super.mayPlaceOn(state, worldIn, pos);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int event, int param) {
        super.triggerEvent(state, world, pos, event, param);
        BlockEntity tileentity = world.getBlockEntity(pos);
        return tileentity != null && tileentity.triggerEvent(event, param);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return this.blockEntityType.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BotaniaBlock.createTickerHelper(type, this.blockEntityType.get(), SpecialFlowerBlockEntity::commonTick);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ((SpecialFlowerBlockEntity)level.getBlockEntity(pos)).setPlacedBy(level, pos, state, placer, stack);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (this.hasComparatorOutput && !newState.hasAnalogOutputSignal()) {
            level.updateNeighbourForOutputSignal(pos, newState.getBlock());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        SpecialFlowerBlock.redstoneParticlesIfPowered(state, world, pos, rand);
    }

    public boolean hasAnalogOutputSignal(BlockState bs) {
        return this.hasComparatorOutput;
    }

    public int getAnalogOutputSignal(BlockState bs, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpecialFlowerBlockEntity) {
            SpecialFlowerBlockEntity flower = (SpecialFlowerBlockEntity)blockEntity;
            return flower.getComparatorSignal();
        }
        return 0;
    }

    public static void redstoneParticlesIfPowered(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof FunctionalFlowerBlockEntity) {
            VoxelShape shape;
            FunctionalFlowerBlockEntity flower = (FunctionalFlowerBlockEntity)te;
            if (rand.nextBoolean() && flower.acceptsRedstone() && flower.redstoneSignal > 0 && !(shape = state.getShape((BlockGetter)world, pos)).isEmpty()) {
                AABB localBox = shape.bounds();
                double x = (double)pos.getX() + localBox.minX + rand.nextDouble() * (localBox.maxX - localBox.minX);
                double y = (double)pos.getY() + localBox.minY + rand.nextDouble() * (localBox.maxY - localBox.minY);
                double z = (double)pos.getZ() + localBox.minZ + rand.nextDouble() * (localBox.maxZ - localBox.minZ);
                world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

