/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.SparkTinkererBlockEntity;
import vazkii.botania.common.item.SparkAugmentItem;

public class SparkTinkererBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = SparkTinkererBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public SparkTinkererBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.getBestNeighborSignal(pos) > 0;
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (power && !powered) {
            ((SparkTinkererBlockEntity)world.getBlockEntity(pos)).doSwap();
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SparkTinkererBlockEntity changer = (SparkTinkererBlockEntity)world.getBlockEntity(pos);
        ItemStack cstack = changer.getItemHandler().getItem(0);
        if (!cstack.isEmpty()) {
            changer.getItemHandler().setItem(0, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(cstack);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (!pstack.isEmpty() && pstack.getItem() instanceof SparkAugmentItem) {
            changer.getItemHandler().setItem(0, pstack.split(1));
            changer.setChanged();
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        Item item;
        SparkTinkererBlockEntity changer = (SparkTinkererBlockEntity)world.getBlockEntity(pos);
        ItemStack stack = changer.getItemHandler().getItem(0);
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof SparkAugmentItem) {
            SparkAugmentItem upgrade = (SparkAugmentItem)item;
            return upgrade.type.ordinal() + 1;
        }
        return 0;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SparkTinkererBlockEntity(pos, state);
    }
}

