/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

public class PlatformBlock
extends BotaniaBlock
implements ManaCollisionGhost,
EntityBlock {
    private final Variant variant;

    public PlatformBlock(@NotNull Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public Variant getVariant() {
        return this.variant;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        PlatformBlockEntity platform;
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof PlatformBlockEntity && (platform = (PlatformBlockEntity)te).getCamoState() != null) {
            return platform.getCamoState().getShape(world, pos);
        }
        return super.getShape(state, world, pos, context);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext context) {
        if (this.variant.collide.test(pos, context)) {
            return super.getShape(state, world, pos, context);
        }
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.block();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PlatformBlockEntity(pos, state);
    }

    @Override
    public ManaCollisionGhost.Behaviour getGhostBehaviour() {
        return ManaCollisionGhost.Behaviour.SKIP_ALL;
    }

    public static boolean isValidBlock(@Nullable BlockState state, Level world, BlockPos pos) {
        return state != null && (state.isSolidRender((BlockGetter)world, pos) || state.getRenderShape() == RenderShape.MODEL);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.variant.indestructible) {
            tooltip.add((Component)Component.translatable((String)"botaniamisc.creative").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.getBlockEntity(pos);
        ItemStack currentStack = player.getItemInHand(hand);
        if (this.variant.indestructible && !player.isCreative()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!currentStack.isEmpty() && Block.byItem((Item)currentStack.getItem()) != Blocks.AIR && tile instanceof PlatformBlockEntity) {
            PlatformBlockEntity camo = (PlatformBlockEntity)tile;
            BlockPlaceContext ctx = new BlockPlaceContext(player, hand, currentStack, hit);
            BlockState changeState = Block.byItem((Item)currentStack.getItem()).getStateForPlacement(ctx);
            if (PlatformBlock.isValidBlock(changeState, world, pos) && !(changeState.getBlock() instanceof PlatformBlock) && !changeState.isAir()) {
                if (!world.isClientSide) {
                    camo.setCamoState(changeState);
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        } else if (!currentStack.isEmpty() && currentStack.is(BotaniaItems.phantomInk) && tile instanceof PlatformBlockEntity) {
            PlatformBlockEntity camo = (PlatformBlockEntity)tile;
            if (!world.isClientSide) {
                camo.setCamoState(Blocks.BARRIER.defaultBlockState());
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static enum Variant {
        ABSTRUSE(false, (pos, context) -> {
            if (context instanceof EntityCollisionContext) {
                EntityCollisionContext econtext = (EntityCollisionContext)context;
                Entity e = econtext.getEntity();
                return e == null || e.getY() > (double)pos.getY() + 0.9 && !context.isDescending();
            }
            return true;
        }),
        SPECTRAL(false, (pos, context) -> false),
        INFRANGIBLE(true, (pos, context) -> true);

        public final boolean indestructible;
        public final BiPredicate<BlockPos, CollisionContext> collide;

        private Variant(boolean i, BiPredicate<BlockPos, CollisionContext> p) {
            this.indestructible = i;
            this.collide = p;
        }
    }
}

