/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.PetalApothecaryBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class PetalApothecaryBlock
extends BotaniaBlock
implements EntityBlock {
    public static final EnumProperty<PetalApothecary.State> FLUID = EnumProperty.create((String)"fluid", PetalApothecary.State.class);
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape PILLAR = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape TOP = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.box((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_INTERACT = Shapes.or((VoxelShape)Shapes.or((VoxelShape)BASE, (VoxelShape)PILLAR), (VoxelShape)TOP);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)SHAPE_INTERACT, (VoxelShape)TOP_CUTOUT, (BooleanOp)BooleanOp.ONLY_FIRST);
    public final Variant variant;

    protected PetalApothecaryBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FLUID, (Comparable)((Object)PetalApothecary.State.EMPTY)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FLUID});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE_INTERACT;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            PetalApothecaryBlockEntity tile = (PetalApothecaryBlockEntity)world.getBlockEntity(pos);
            if (tile.collideEntityItem(itemEntity)) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof PetalApothecaryBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        PetalApothecaryBlockEntity apothecary = (PetalApothecaryBlockEntity)blockEntity;
        boolean mainHandEmpty = player.getMainHandItem().isEmpty();
        if (apothecary.canAddLastRecipe() && mainHandEmpty) {
            return apothecary.trySetLastRecipe(player);
        }
        if (!apothecary.isEmpty() && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(apothecary, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(apothecary);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (this.tryWithdrawFluid(player, hand, apothecary, pos) || this.tryDepositFluid(player, hand, apothecary, pos)) {
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (world.random.nextInt(20) == 1 && state.getValue(FLUID) == PetalApothecary.State.EMPTY) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)PetalApothecary.State.WATER)));
            world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    private boolean tryWithdrawFluid(Player player, InteractionHand hand, PetalApothecaryBlockEntity altar, BlockPos pos) {
        Fluid fluid = altar.getFluid().asVanilla();
        if (fluid == Fluids.EMPTY || fluid == Fluids.WATER && XplatAbstractions.INSTANCE.gogLoaded()) {
            return false;
        }
        boolean success = XplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
        if (success) {
            altar.setFluid(PetalApothecary.State.EMPTY);
            if (fluid == Fluids.WATER) {
                player.level().playSound(player, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (fluid == Fluids.LAVA) {
                player.level().playSound(player, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return success;
    }

    private boolean tryDepositFluid(Player player, InteractionHand hand, PetalApothecaryBlockEntity altar, BlockPos pos) {
        if (altar.getFluid() != PetalApothecary.State.EMPTY) {
            return false;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.is(BotaniaItems.waterRod) && ManaItemHandler.instance().requestManaExact(stack, player, 75, false)) {
            ManaItemHandler.instance().requestManaExact(stack, player, 75, true);
            altar.setFluid(PetalApothecary.State.WATER);
            player.level().playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.WATER)) {
            altar.setFluid(PetalApothecary.State.WATER);
            player.level().playSound(player, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (XplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.LAVA)) {
            altar.setFluid(PetalApothecary.State.LAVA);
            player.level().playSound(player, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PetalApothecaryBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return PetalApothecaryBlock.createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::clientTick);
        }
        return PetalApothecaryBlock.createTickerHelper(type, BotaniaBlockEntities.ALTAR, PetalApothecaryBlockEntity::serverTick);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        boolean blockChanged;
        boolean bl = blockChanged = !state.is(newState.getBlock());
        if (blockChanged || newState.getValue(FLUID) != PetalApothecary.State.WATER) {
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            if (blockChanged) {
                super.onRemove(state, world, pos, newState, isMoving);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return state.getValue(FLUID) == PetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY,
        LIVINGROCK,
        DEEPSLATE;

    }
}

