/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ManaStormEntity;

public class ManastormChargeBlock
extends BotaniaBlock {
    public ManastormChargeBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public static class ManaTriggerImpl
    implements ManaTrigger {
        private final Level world;
        private final BlockPos pos;
        private final BlockState state;

        public ManaTriggerImpl(Level world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        @Override
        public void onBurstCollision(ManaBurst burst) {
            if (!burst.isFake() && !this.world.isClientSide) {
                this.world.levelEvent(2001, this.pos, Block.getId((BlockState)this.state));
                this.world.removeBlock(this.pos, false);
                ManaStormEntity storm = (ManaStormEntity)BotaniaEntities.MANA_STORM.create(this.world);
                storm.burstColor = burst.getColor();
                storm.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5);
                this.world.addFreshEntity((Entity)storm);
            }
        }
    }
}

