/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.LuminizerBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

public class LuminizerBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = LuminizerBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public final LuminizerVariant variant;

    protected LuminizerBlock(LuminizerVariant variant, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = variant;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof LuminizerBlockEntity) {
            LuminizerBlockEntity relay = (LuminizerBlockEntity)te;
            if (stack.is(BotaniaItems.phantomInk) && !relay.isNoParticle()) {
                if (!world.isClientSide) {
                    stack.shrink(1);
                    relay.setNoParticle();
                    world.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(relay);
                }
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
            if (!stack.is(Items.ENDER_PEARL)) {
                relay.mountEntity((Entity)player);
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide());
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.isClientSide && this.variant == LuminizerVariant.TOGGLE) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            } else if (!((Boolean)state.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isSignalSource(BlockState state) {
        return this.variant == LuminizerVariant.DETECTOR;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction s) {
        return this.variant == LuminizerVariant.DETECTOR && (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? 15 : 0;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LuminizerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return LuminizerBlock.createTickerHelper(type, BotaniaBlockEntities.LIGHT_RELAY, level.isClientSide ? LuminizerBlockEntity::clientTick : LuminizerBlockEntity::serverTick);
    }
}

