/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.block_entity.FakeAirBlockEntity;

public class FakeAirBlock
extends AirBlock
implements EntityBlock,
LiquidBlockContainer {
    public FakeAirBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.shouldRemove(world, pos)) {
            world.scheduleTick(pos, (Block)this, 4);
        }
    }

    private boolean shouldRemove(Level world, BlockPos pos) {
        FakeAirBlockEntity fakeAir;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return !(blockEntity instanceof FakeAirBlockEntity) || !(fakeAir = (FakeAirBlockEntity)blockEntity).canStay();
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (this.shouldRemove((Level)world, pos)) {
            world.setBlockAndUpdate(pos, rand.nextInt(10) == 0 ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState());
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FakeAirBlockEntity(pos, state);
    }

    public boolean canPlaceLiquid(Player player, BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return false;
    }
}

