/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;
import vazkii.botania.api.BotaniaAPI;

public final class BotaniaBannerPatterns {
    private static final List<ResourceKey<BannerPattern>> ALL = new ArrayList<ResourceKey<BannerPattern>>();
    public static final ResourceKey<BannerPattern> FLOWER = BotaniaBannerPatterns.make("flower");
    public static final ResourceKey<BannerPattern> LEXICON = BotaniaBannerPatterns.make("lexicon");
    public static final ResourceKey<BannerPattern> LOGO = BotaniaBannerPatterns.make("logo");
    public static final ResourceKey<BannerPattern> SAPLING = BotaniaBannerPatterns.make("sapling");
    public static final ResourceKey<BannerPattern> TINY_POTATO = BotaniaBannerPatterns.make("tiny_potato");
    public static final ResourceKey<BannerPattern> SPARK_DISPERSIVE = BotaniaBannerPatterns.make("spark_dispersive");
    public static final ResourceKey<BannerPattern> SPARK_DOMINANT = BotaniaBannerPatterns.make("spark_dominant");
    public static final ResourceKey<BannerPattern> SPARK_RECESSIVE = BotaniaBannerPatterns.make("spark_recessive");
    public static final ResourceKey<BannerPattern> SPARK_ISOLATED = BotaniaBannerPatterns.make("spark_isolated");
    public static final ResourceKey<BannerPattern> FISH = BotaniaBannerPatterns.make("fish");
    public static final ResourceKey<BannerPattern> AXE = BotaniaBannerPatterns.make("axe");
    public static final ResourceKey<BannerPattern> HOE = BotaniaBannerPatterns.make("hoe");
    public static final ResourceKey<BannerPattern> PICKAXE = BotaniaBannerPatterns.make("pickaxe");
    public static final ResourceKey<BannerPattern> SHOVEL = BotaniaBannerPatterns.make("shovel");
    public static final ResourceKey<BannerPattern> SWORD = BotaniaBannerPatterns.make("sword");

    private static ResourceKey<BannerPattern> make(String hashName) {
        ResourceKey bannerKey = ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)BotaniaAPI.botaniaRL(hashName));
        ALL.add((ResourceKey<BannerPattern>)bannerKey);
        return bannerKey;
    }

    public static void submitRegistrations(BiConsumer<BannerPattern, ResourceLocation> consumer) {
        for (ResourceKey<BannerPattern> resourceKey : ALL) {
            BannerPattern pattern = new BannerPattern(resourceKey.location(), "block.minecraft.banner." + resourceKey.location().toLanguageKey());
            consumer.accept(pattern, resourceKey.location());
        }
    }
}

