/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;

public class RelicBindTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("relic_bind");
    public static final RelicBindTrigger INSTANCE = new RelicBindTrigger();

    private RelicBindTrigger() {
    }

    public void trigger(ServerPlayer player, ItemStack relic) {
        this.trigger(player, instance -> instance.test(relic));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> relic) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.optionalFieldOf("relic").forGetter(Instance::relic)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> bound(ItemLike relicItem) {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{relicItem}).build())));
        }

        boolean test(ItemStack stack) {
            return this.relic.isEmpty() || this.relic.get().test(stack);
        }
    }
}

