/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;

public class ManaBlasterTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("fire_mana_blaster");
    public static final ManaBlasterTrigger INSTANCE = new ManaBlasterTrigger();

    private ManaBlasterTrigger() {
    }

    public void trigger(ServerPlayer player, ItemStack stack) {
        this.trigger(player, instance -> instance.test(stack, player));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<EntityPredicate> user) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Instance::item), (App)EntityPredicate.CODEC.optionalFieldOf("user").forGetter(Instance::user)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> shoot() {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        boolean test(ItemStack stack, ServerPlayer entity) {
            return !(!this.item.isEmpty() && !this.item.get().test(stack) || !this.user.isEmpty() && !this.user.get().matches(entity, (Entity)entity));
        }
    }
}

