/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;

public class LokiPlaceTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("loki_placed_blocks");
    public static final LokiPlaceTrigger INSTANCE = new LokiPlaceTrigger();

    private LokiPlaceTrigger() {
    }

    public void trigger(ServerPlayer player, ItemStack ring, int blocksPlaced) {
        this.trigger(player, instance -> instance.test(ring, blocksPlaced));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> ring, MinMaxBounds.Ints blocksPlaced) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.optionalFieldOf("ring").forGetter(Instance::ring), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("blocks_placed", (Object)MinMaxBounds.Ints.ANY).forGetter(Instance::blocksPlaced)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> blocksPlaced(MinMaxBounds.Ints blocksPlaced) {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty(), blocksPlaced));
        }

        boolean test(ItemStack ring, int blocksPlaced) {
            return (this.ring.isEmpty() || this.ring.get().test(ring)) && this.blocksPlaced.matches(blocksPlaced);
        }
    }
}

