/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.entity.GaiaGuardianEntity;

public class GaiaGuardianNoArmorTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("gaia_guardian_no_armor");
    public static final GaiaGuardianNoArmorTrigger INSTANCE = new GaiaGuardianNoArmorTrigger();

    private GaiaGuardianNoArmorTrigger() {
    }

    public void trigger(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
        this.trigger(player, instance -> instance.test(player, guardian, src));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> guardian, Optional<DamageSourcePredicate> killingBlow) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)EntityPredicate.CODEC.optionalFieldOf("guardian").forGetter(Instance::guardian), (App)DamageSourcePredicate.CODEC.optionalFieldOf("killingBlow").forGetter(Instance::killingBlow)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> unarmoredKill() {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        boolean test(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
            return !(!this.guardian.isEmpty() && !this.guardian.get().matches(player, (Entity)guardian) || !this.killingBlow.isEmpty() && !this.killingBlow.get().matches(player, src));
        }
    }
}

