/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import vazkii.botania.api.BotaniaAPI;

public class CorporeaRequestTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("corporea_index_request");
    public static final CorporeaRequestTrigger INSTANCE = new CorporeaRequestTrigger();

    private CorporeaRequestTrigger() {
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, int count) {
        this.trigger(player, instance -> instance.test(world, pos, count));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, MinMaxBounds.Ints extracted, Optional<LocationPredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("extracted", (Object)MinMaxBounds.Ints.ANY).forGetter(Instance::extracted), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(Instance::location)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> numExtracted(MinMaxBounds.Ints extracted) {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), extracted, Optional.empty()));
        }

        boolean test(ServerLevel world, BlockPos pos, int count) {
            return this.extracted.matches(count) && (this.location.isEmpty() || this.location.get().matches(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        }
    }
}

