/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.BotaniaAPI;

public class AlfheimPortalTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("open_elf_portal");
    public static final AlfheimPortalTrigger INSTANCE = new AlfheimPortalTrigger();

    private AlfheimPortalTrigger() {
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, ItemStack wand) {
        this.trigger(player, instance -> instance.test(world, pos, wand));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> wand, Optional<LocationPredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.optionalFieldOf("wand").forGetter(Instance::wand), (App)LocationPredicate.CODEC.optionalFieldOf("location").forGetter(Instance::location)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> activatedPortal() {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        boolean test(ServerLevel world, BlockPos pos, ItemStack wand) {
            return !(!this.wand.isEmpty() && !this.wand.get().test(wand) || !this.location.isEmpty() && !this.location.get().matches(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
        }
    }
}

