/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import vazkii.botania.api.BotaniaAPI;

public class AlfheimPortalBreadTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = BotaniaAPI.botaniaRL("alf_portal_bread");
    public static final AlfheimPortalBreadTrigger INSTANCE = new AlfheimPortalBreadTrigger();

    private AlfheimPortalBreadTrigger() {
    }

    public void trigger(ServerPlayer player, BlockPos portal) {
        this.trigger(player, instance -> instance.test(player.serverLevel(), portal));
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<LocationPredicate> portalLocation) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)LocationPredicate.CODEC.optionalFieldOf("portal_location").forGetter(Instance::portalLocation)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> sentBread() {
            return INSTANCE.createCriterion((CriterionTriggerInstance)new Instance(Optional.empty(), Optional.empty()));
        }

        boolean test(ServerLevel world, BlockPos portal) {
            return this.portalLocation.isEmpty() || this.portalLocation.get().matches(world, (double)portal.getX(), (double)portal.getY(), (double)portal.getZ());
        }
    }
}

